/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ResizeUtils {
    public static void forceHeight(Component comp, int height) {
        comp.setMinimumSize(new Dimension((int)comp.getMinimumSize().getWidth(), height));
        comp.setMaximumSize(new Dimension((int)comp.getMaximumSize().getWidth(), height));
        comp.setPreferredSize(new Dimension((int)comp.getPreferredSize().getWidth(), height));
        comp.setSize(new Dimension((int)comp.getSize().getWidth(), height));
    }

    public static void forceWidth(Component comp, int width) {
        comp.setMinimumSize(new Dimension(width, (int)comp.getMinimumSize().getHeight()));
        comp.setMaximumSize(new Dimension(width, (int)comp.getMaximumSize().getHeight()));
        comp.setPreferredSize(new Dimension(width, (int)comp.getPreferredSize().getHeight()));
        comp.setSize(new Dimension(width, (int)comp.getSize().getHeight()));
    }

    public static void forceSize(Component comp, Dimension d) {
        comp.setMaximumSize(d);
        comp.setMaximumSize(d);
        comp.setPreferredSize(d);
        comp.setSize(d);
    }

    public static void looseForceHeight(Component comp, int height) {
        comp.setMinimumSize(new Dimension(10, height));
        comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
    }

    public static void looseForceWidth(Component comp, int width) {
        comp.setMinimumSize(new Dimension(width, 10));
        comp.setMaximumSize(new Dimension(width, Integer.MAX_VALUE));
    }

    public static void updateSize(JButton comp, List<Action> items) {
        if (comp.getText() == null && (items == null || items.isEmpty())) {
            return;
        }
        Font font = comp.getFont();
        FontMetrics fm = comp.getFontMetrics(font);
        Rectangle largest = new Rectangle();
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        if (comp.getText() != null && !comp.getText().isEmpty()) {
            Rectangle r;
            SwingUtilities.layoutCompoundLabel(comp, fm, comp.getText(), comp.getIcon(), comp.getVerticalAlignment(), comp.getHorizontalAlignment(), comp.getVerticalTextPosition(), comp.getHorizontalTextPosition(), viewR, iconR, textR, comp.getIconTextGap());
            largest = r = iconR.union(textR);
        } else {
            for (Action action : items) {
                Icon icon = (Icon)action.getValue("SmallIcon");
                String text = (String)action.getValue("Name");
                iconR.y = 0;
                iconR.x = 0;
                iconR.width = 0;
                iconR.height = 0;
                textR.y = 0;
                textR.x = 0;
                textR.width = 0;
                textR.height = 0;
                viewR.y = 0;
                viewR.x = 0;
                viewR.width = Short.MAX_VALUE;
                viewR.height = Short.MAX_VALUE;
                SwingUtilities.layoutCompoundLabel(comp, fm, text, icon, 0, 0, 0, 11, viewR, iconR, textR, text == null ? 0 : 4);
                Rectangle r = iconR.union(textR);
                largest.height = Math.max(r.height, largest.height);
                largest.width = Math.max(r.width, largest.width);
            }
        }
        Insets insets = comp.getInsets();
        largest.width += insets.left + insets.right;
        largest.height += insets.top + insets.bottom;
        largest.height = Math.max(comp.getMinimumSize().height, largest.height);
        comp.setMaximumSize(new Dimension(200, 100));
        comp.setMinimumSize(largest.getSize());
        comp.setPreferredSize(largest.getSize());
        comp.setSize(largest.getSize());
        comp.revalidate();
        comp.repaint();
    }
}

