/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.activation.api.ActivationItem;
import org.limewire.core.api.Application;
import org.limewire.ui.swing.activation.ActivationInfoAction;
import org.limewire.ui.swing.activation.ActivationItemComparator;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.table.BasicJXTable;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.table.TableColors;
import org.limewire.ui.swing.table.TableRendererEditor;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class SetupActivationTable
extends BasicJXTable {
    private final String[] columnNames = new String[]{I18n.tr("Feature Type"), I18n.tr("Expires")};
    @Resource
    private Color columnNameColor;
    @Resource
    private Icon checkIcon;
    @Resource
    private Color headerBackgroundColor;
    @Resource
    private Font headerFont;
    @Resource
    private Icon infoIcon;
    protected MouseMotionListener mouseOverEditorListener;
    private Application application;

    public SetupActivationTable(List<ActivationItem> activationItems, Application application) {
        this.application = application;
        GuiUtils.assignResources(this);
        this.setModel(new ActivationTableModel(activationItems));
        Collections.sort(activationItems, new ActivationItemComparator());
        this.getColumn(this.columnNames[0]).setCellRenderer(new LicenseTypeRendererEditor());
        this.getColumn(this.columnNames[0]).setCellEditor(new LicenseTypeRendererEditor());
        this.getColumn(this.columnNames[0]).setMinWidth(200);
        this.getColumn(this.columnNames[1]).setCellRenderer(new DateRenderer());
        this.getColumn(this.columnNames[1]).setMinWidth(100);
        this.getColumn(this.columnNames[1]).setMaxWidth(150);
        this.getTableHeader().setDefaultRenderer(new TableHeaderRenderer());
        JTableHeader header = this.getTableHeader();
        header.setMinimumSize(new Dimension(400, 27));
        header.setPreferredSize(new Dimension(400, 27));
        this.initTable();
        this.setupHighlighters();
    }

    public Color getHeaderColor() {
        return this.headerBackgroundColor;
    }

    private void initTable() {
        this.setRowHeight(29);
        this.setShowGrid(false, false);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setFillsViewportHeight(true);
        this.setSortable(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.mouseOverEditorListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int col;
                int row = SetupActivationTable.this.rowAtPoint(e.getPoint());
                if (SetupActivationTable.this.isCellEditable(row, col = SetupActivationTable.this.columnAtPoint(e.getPoint())) && (row != SetupActivationTable.this.getEditingRow() || col != SetupActivationTable.this.getEditingColumn())) {
                    SetupActivationTable.this.editCellAt(row, col);
                } else {
                    SetupActivationTable.this.maybeCancelEditing();
                }
            }
        };
        this.addMouseMotionListener(this.mouseOverEditorListener);
    }

    private void setupHighlighters() {
        TableColors tableColors = new TableColors();
        ColorHighlighter unsupportedHighlighter = new ColorHighlighter(new GrayHighlightPredicate(), null, tableColors.getDisabledForegroundColor(), null, tableColors.getDisabledForegroundColor());
        this.addHighlighter(unsupportedHighlighter);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row >= this.getRowCount() || col >= this.getColumnCount() || row < 0 || col < 0) {
            return false;
        }
        return this.getColumnModel().getColumn(col).getCellEditor() != null;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            this.removeEditor();
        }
    }

    private void maybeCancelEditing() {
        Point mousePosition = this.getMousePosition();
        if (this.getCellEditor() != null && (mousePosition == null || this.rowAtPoint(mousePosition) == -1 || this.columnAtPoint(mousePosition) == -1)) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    private class TableHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        JLabel headerLabel = new JLabel();
        Component strut = Box.createHorizontalStrut(10);

        public TableHeaderRenderer() {
            this.headerLabel.setFont(SetupActivationTable.this.headerFont);
            this.headerLabel.setForeground(SetupActivationTable.this.columnNameColor);
            this.headerLabel.setOpaque(false);
            this.setBackground(SetupActivationTable.this.headerBackgroundColor);
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setHorizontalTextPosition(2);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setLayout(new MigLayout("filly, insets 0 0 0 0, hidemode 3"));
            this.add(this.strut, "align 0% 50%, hidemode 3");
            this.add((Component)this.headerLabel, "align 0% 50%");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.strut.setVisible(column == 0);
            this.headerLabel.setText(value.toString());
            return this;
        }
    }

    private class DateRenderer
    extends DefaultLimeTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof ActivationItem) {
                ActivationItem item = (ActivationItem)value;
                this.setText(GuiUtils.date2String(item.getDateExpired()));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class LicenseTypeRendererEditor
    extends TableRendererEditor {
        private final JLabel checkMarkLabel;
        private final JLabel nameLabel = new JLabel();
        private final Component strut1;
        private final Component strut2;
        private final IconButton infoButton;
        private ActivationItem cellEditorValue = null;

        public LicenseTypeRendererEditor() {
            this.checkMarkLabel = new JLabel(SetupActivationTable.this.checkIcon);
            this.checkMarkLabel.setVisible(false);
            this.strut1 = Box.createHorizontalStrut(1);
            this.strut1.setVisible(false);
            this.strut2 = Box.createHorizontalStrut(0);
            this.strut2.setVisible(false);
            this.infoButton = new IconButton(SetupActivationTable.this.infoIcon);
            this.infoButton.addActionListener(new ActivationInfoAction(this, SetupActivationTable.this, SetupActivationTable.this.application));
            this.infoButton.setVisible(false);
            this.setLayout(new MigLayout("filly, insets 0 5 0 5, hidemode 3"));
            this.add((Component)this.checkMarkLabel, "align 0% 50%");
            this.add(this.strut1, "align 0% 50%, hidemode 3");
            this.add((Component)this.infoButton, "align 0% 50%, hidemode 3");
            this.add(this.strut2, "align 0% 50%, hidemode 3");
            this.add((Component)this.nameLabel, "align 0% 50%");
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ActivationItem item = (ActivationItem)value;
            this.updateComponents(item);
            return this;
        }

        @Override
        protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cellEditorValue = (ActivationItem)value;
            this.updateComponents(this.cellEditorValue);
            return this;
        }

        private void updateComponents(ActivationItem item) {
            this.checkMarkLabel.setVisible(item.getStatus() == ActivationItem.Status.ACTIVE);
            boolean showInfoButton = item.getStatus() == ActivationItem.Status.UNAVAILABLE || item.getStatus() == ActivationItem.Status.UNUSEABLE_LW || item.getStatus() == ActivationItem.Status.UNUSEABLE_OS;
            this.strut1.setVisible(showInfoButton);
            this.infoButton.setVisible(showInfoButton);
            this.strut2.setVisible(showInfoButton);
            if (item.getStatus() == ActivationItem.Status.ACTIVE) {
                this.nameLabel.setText(item.getLicenseName());
                this.nameLabel.setForeground(Color.BLACK);
            } else if (item.getStatus() == ActivationItem.Status.EXPIRED) {
                this.nameLabel.setText("<html><s>" + item.getLicenseName() + "</s></html>");
                this.nameLabel.setForeground(Color.GRAY);
            } else {
                this.nameLabel.setText("* " + item.getLicenseName());
                this.nameLabel.setForeground(Color.GRAY);
            }
        }

        @Override
        public ActivationItem getCellEditorValue() {
            return this.cellEditorValue;
        }
    }

    private class ActivationTableModel
    extends AbstractTableModel {
        private List<ActivationItem> activationItems;

        public ActivationTableModel(List<ActivationItem> activationItems) {
            this.activationItems = activationItems;
        }

        @Override
        public String getColumnName(int col) {
            return SetupActivationTable.this.columnNames[col].toString();
        }

        @Override
        public int getRowCount() {
            return this.activationItems.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.activationItems.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col != 0) {
                return false;
            }
            return this.activationItems.get(row).getStatus() != ActivationItem.Status.ACTIVE;
        }
    }

    private class GrayHighlightPredicate
    implements HighlightPredicate {
        private GrayHighlightPredicate() {
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            ActivationItem item = (ActivationItem)SetupActivationTable.this.getModel().getValueAt(adapter.row, 0);
            return item.getStatus() != ActivationItem.Status.ACTIVE;
        }
    }
}

