/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.util.SystemUtils;

public class OSUtils {
    private static final Log LOG = LogFactory.getLog(OSUtils.class);
    private static boolean _isWindows;
    private static boolean _isWindowsNT;
    private static boolean _isWindowsXP;
    private static boolean _isWindows7;
    private static boolean _isWindows95;
    private static boolean _isWindows98;
    private static boolean _isWindowsMe;
    private static boolean _isWindowsVista;
    private static int _windowsServicePack;
    private static boolean _supportsTray;
    private static boolean _isMacOSX;
    private static boolean _isLinux;
    private static boolean _isSolaris;
    private static boolean _isOS2;
    @InspectionPoint(value="os_info")
    private static final Inspectable osInspect;

    public static void setOperatingSystems() {
        _isWindows = false;
        _windowsServicePack = 0;
        _isWindowsVista = false;
        _isWindowsNT = false;
        _isWindowsXP = false;
        _isWindows7 = false;
        _isWindows95 = false;
        _isWindows98 = false;
        _isWindowsMe = false;
        _isSolaris = false;
        _isLinux = false;
        _isOS2 = false;
        _isMacOSX = false;
        String os = System.getProperty("os.name").toLowerCase(Locale.US);
        String version = System.getProperty("os.version").toLowerCase(Locale.US);
        boolean bl = _isWindows = os.indexOf("windows") != -1;
        if (os.indexOf("windows nt") != -1) {
            _isWindowsNT = true;
        } else if (os.indexOf("windows xp") != -1) {
            _isWindowsXP = true;
        } else if (os.indexOf("windows 7") != -1) {
            _isWindows7 = true;
        } else if (os.indexOf("windows vista") != -1 && version.startsWith("6.1")) {
            _isWindows7 = true;
        } else if (os.indexOf("windows vista") != -1) {
            _isWindowsVista = true;
        } else if (os.indexOf("windows 95") != -1) {
            _isWindows95 = true;
        } else if (os.indexOf("windows 98") != -1) {
            _isWindows98 = true;
        } else if (os.indexOf("windows me") != -1) {
            _isWindowsMe = true;
        } else if (os.indexOf("solaris") != -1) {
            _isSolaris = true;
        } else if (os.indexOf("linux") != -1) {
            _isLinux = true;
        } else if (os.indexOf("os/2") != -1) {
            _isOS2 = true;
        }
        if (_isWindows || _isLinux) {
            _supportsTray = true;
        }
        if (os.startsWith("mac os") && os.endsWith("x")) {
            _isMacOSX = true;
        }
        if (_isWindowsXP || _isWindowsVista) {
            try {
                String ver = SystemUtils.registryReadText("HKEY_LOCAL_MACHINE", "Software\\Microsoft\\Windows NT\\CurrentVersion", "CSDVersion");
                ver = ver.replaceAll("[^0-9]", "");
                _windowsServicePack = Integer.parseInt(ver);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Windows service pack " + _windowsServicePack);
                }
            }
            catch (IOException e) {
                LOG.debug("Failed to determine Windows service pack", e);
            }
            catch (NumberFormatException e) {
                LOG.debug("Failed to determine Windows service pack", e);
            }
        }
    }

    public static String getOS() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getOSArch() {
        return System.getProperty("os.arch");
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindows7() {
        return _isWindows7;
    }

    public static boolean isWindowsNT() {
        return _isWindowsNT;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindowsMe() {
        return _isWindowsMe;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isSocketChallengedWindows() {
        return _isWindowsXP || _isWindowsVista && _windowsServicePack < 3;
    }

    public static boolean isAVGCompatibleWindows() {
        return _isWindows7 || _isWindowsVista || _isWindowsXP && _windowsServicePack >= 2;
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isPOSIX() {
        return _isLinux || _isSolaris || _isMacOSX;
    }

    public static boolean isHighLoadOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT;
    }

    public static boolean isGoodWindows() {
        return OSUtils.isWindows() && OSUtils.isHighLoadOS();
    }

    public static boolean supportsTrash() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    public static int getMaxPathLength() {
        if (OSUtils.isWindows()) {
            return 259;
        }
        if (OSUtils.isLinux()) {
            return 4095;
        }
        return 1023;
    }

    static {
        OSUtils.setOperatingSystems();
        osInspect = new OSInspecter();
    }

    private static class OSInspecter
    implements Inspectable {
        private OSInspecter() {
        }

        @Override
        public Object inspect() {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("os_name", OSUtils.getOS());
            data.put("os_ver", OSUtils.getOSVersion());
            data.put("os_arch", OSUtils.getOSArch());
            data.put("num_cpus", Runtime.getRuntime().availableProcessors());
            return data;
        }
    }
}

