/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.prefs.Preferences;
import org.limewire.friend.api.PasswordManager;
import org.limewire.inject.LazySingleton;
import org.limewire.security.certificate.CipherProvider;
import org.limewire.xmpp.client.impl.Password;

@LazySingleton
public class PasswordManagerImpl
implements PasswordManager {
    static final String PREFERENCES_NODE = "/limewire/xmpp/auth";
    private CipherProvider cipherProvider;

    @Inject
    public PasswordManagerImpl(CipherProvider cipherProvider) {
        this.cipherProvider = cipherProvider;
    }

    @Override
    public String loadPassword(String userName) throws IOException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("userName cannot be null or empty");
        }
        String encryptedPassword = this.loadEncryptedPassword(userName);
        Password pwd = new Password(this.cipherProvider, encryptedPassword, true);
        try {
            return pwd.decryptPassword();
        }
        catch (IOException e) {
            throw new IOException("Error decrypting password", e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error decrypting password", e);
        }
    }

    @Override
    public void storePassword(String userName, String rawPassword) throws IOException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("username cannot be null or empty");
        }
        if (rawPassword == null || rawPassword.isEmpty()) {
            throw new IllegalArgumentException("password cannot be null or empty");
        }
        Preferences prefs = this.getPreferences();
        Password pwd = new Password(this.cipherProvider, rawPassword, false);
        try {
            prefs.put(userName, pwd.encryptPassword());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Error encrypting password", e);
        }
        catch (IOException e) {
            throw new IOException("Error encrypting password", e);
        }
    }

    @Override
    public void removePassword(String userName) {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("userName must not be null or empty");
        }
        Preferences prefs = this.getPreferences();
        prefs.remove(userName);
    }

    private String loadEncryptedPassword(String userName) {
        Preferences prefs = this.getPreferences();
        return prefs.get(userName, "");
    }

    private Preferences getPreferences() {
        return Preferences.userRoot().node(PREFERENCES_NODE);
    }
}

