/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.ChatStateManager;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionConfiguration;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.api.FriendRequestEvent;
import org.limewire.friend.api.RosterEvent;
import org.limewire.friend.api.feature.AddressFeature;
import org.limewire.friend.api.feature.AuthTokenFeature;
import org.limewire.friend.api.feature.ConnectBackRequestFeature;
import org.limewire.friend.api.feature.FeatureEvent;
import org.limewire.friend.api.feature.FeatureRegistry;
import org.limewire.friend.api.feature.FileOfferFeature;
import org.limewire.friend.api.feature.LibraryChangedNotifierFeature;
import org.limewire.friend.impl.feature.LimewireFeatureInitializer;
import org.limewire.friend.impl.feature.NoSaveFeature;
import org.limewire.friend.impl.util.PresenceUtils;
import org.limewire.listener.AsynchronousEventBroadcaster;
import org.limewire.listener.AsynchronousEventMulticaster;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventRebroadcaster;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.address.AddressFactory;
import org.limewire.util.StringUtils;
import org.limewire.xmpp.activity.XmppActivityEvent;
import org.limewire.xmpp.api.client.JabberSettings;
import org.limewire.xmpp.client.impl.ConnectionConfigurationFactory;
import org.limewire.xmpp.client.impl.IdleStatusMonitor;
import org.limewire.xmpp.client.impl.IdleStatusMonitorFactory;
import org.limewire.xmpp.client.impl.PresenceImpl;
import org.limewire.xmpp.client.impl.SubscriptionListener;
import org.limewire.xmpp.client.impl.XMPPFriendImpl;
import org.limewire.xmpp.client.impl.features.NoSaveFeatureInitializer;
import org.limewire.xmpp.client.impl.messages.address.AddressIQListener;
import org.limewire.xmpp.client.impl.messages.address.AddressIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.address.AddressIQProvider;
import org.limewire.xmpp.client.impl.messages.authtoken.AuthTokenIQListener;
import org.limewire.xmpp.client.impl.messages.authtoken.AuthTokenIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.authtoken.AuthTokenIQProvider;
import org.limewire.xmpp.client.impl.messages.connectrequest.ConnectBackRequestIQListener;
import org.limewire.xmpp.client.impl.messages.connectrequest.ConnectBackRequestIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.connectrequest.ConnectBackRequestIQProvider;
import org.limewire.xmpp.client.impl.messages.discoinfo.DiscoInfoListener;
import org.limewire.xmpp.client.impl.messages.filetransfer.FileTransferIQ;
import org.limewire.xmpp.client.impl.messages.filetransfer.FileTransferIQListener;
import org.limewire.xmpp.client.impl.messages.filetransfer.FileTransferIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.library.LibraryChangedIQ;
import org.limewire.xmpp.client.impl.messages.library.LibraryChangedIQListener;
import org.limewire.xmpp.client.impl.messages.library.LibraryChangedIQListenerFactory;
import org.limewire.xmpp.client.impl.messages.nosave.NoSaveIQ;

public class XMPPFriendConnectionImpl
implements FriendConnection {
    private static final Log LOG = LogFactory.getLog(XMPPFriendConnectionImpl.class);
    private final FriendConnectionConfiguration configuration;
    private final EventBroadcaster<FriendRequestEvent> friendRequestBroadcaster;
    private final AsynchronousEventMulticaster<FriendConnectionEvent> connectionMulticaster;
    private final AddressFactory addressFactory;
    private final EventMulticaster<FeatureEvent> featureSupport;
    private final ListeningExecutorService executorService;
    private final List<ConnectionConfigurationFactory> connectionConfigurationFactories;
    private final AddressIQListenerFactory addressIQListenerFactory;
    private final AuthTokenIQListenerFactory authTokenIQListenerFactory;
    private final LibraryChangedIQListenerFactory libraryChangedIQListenerFactory;
    private volatile AddressIQListener addressIQListener;
    private volatile AuthTokenIQListener authTokenIQListener;
    private volatile LibraryChangedIQListener libraryChangedIQListener;
    private volatile ConnectBackRequestIQListener connectRequestIQListener;
    private volatile FileTransferIQListener fileTransferIQListener;
    private final EventListenerList<RosterEvent> rosterListeners;
    private final Map<String, XMPPFriendImpl> friends;
    private final SmackConnectionListener smackConnectionListener;
    private final AtomicBoolean loggedIn = new AtomicBoolean(false);
    private final AtomicBoolean loggingIn = new AtomicBoolean(false);
    private volatile XMPPConnection connection;
    private volatile DiscoInfoListener discoInfoListener;
    private final ConnectBackRequestIQListenerFactory connectBackRequestIQListenerFactory;
    private final FileTransferIQListenerFactory fileTransferIQListenerFactory;
    private final ListenerSupport<FriendPresenceEvent> friendPresenceSupport;
    private final FeatureRegistry featureRegistry;
    private final IdleStatusMonitorFactory idleStatusMonitorFactory;
    private IdleStatusMonitor idleStatusMonitor;
    private volatile NoSaveFeatureInitializer noSaveFeatureInitializer;
    private final JabberSettings jabberSettings;
    private final ListenerSupport<XmppActivityEvent> xmppActivitySupport;
    private EventListener<XmppActivityEvent> xmppActivityListener;

    @Inject
    public XMPPFriendConnectionImpl(@Assisted FriendConnectionConfiguration configuration, @Assisted ListeningExecutorService executorService, AsynchronousEventBroadcaster<RosterEvent> rosterBroadcaster, EventBroadcaster<FriendRequestEvent> friendRequestBroadcaster, AsynchronousEventMulticaster<FriendConnectionEvent> connectionMulticaster, AddressFactory addressFactory, EventMulticaster<FeatureEvent> featureSupport, List<ConnectionConfigurationFactory> connectionConfigurationFactories, AddressIQListenerFactory addressIQListenerFactory, AuthTokenIQListenerFactory authTokenIQListenerFactory, ConnectBackRequestIQListenerFactory connectBackRequestIQListenerFactory, LibraryChangedIQListenerFactory libraryChangedIQListenerFactory, FileTransferIQListenerFactory fileTransferIQListenerFactory, ListenerSupport<FriendPresenceEvent> friendPresenceSupport, FeatureRegistry featureRegistry, IdleStatusMonitorFactory idleStatusMonitorFactory, JabberSettings jabberSettings, ListenerSupport<XmppActivityEvent> xmppActivitySupport) {
        this.configuration = configuration;
        this.friendRequestBroadcaster = friendRequestBroadcaster;
        this.connectionMulticaster = connectionMulticaster;
        this.addressFactory = addressFactory;
        this.featureSupport = featureSupport;
        this.executorService = executorService;
        this.connectionConfigurationFactories = connectionConfigurationFactories;
        this.addressIQListenerFactory = addressIQListenerFactory;
        this.authTokenIQListenerFactory = authTokenIQListenerFactory;
        this.libraryChangedIQListenerFactory = libraryChangedIQListenerFactory;
        this.connectBackRequestIQListenerFactory = connectBackRequestIQListenerFactory;
        this.fileTransferIQListenerFactory = fileTransferIQListenerFactory;
        this.friendPresenceSupport = friendPresenceSupport;
        this.featureRegistry = featureRegistry;
        this.idleStatusMonitorFactory = idleStatusMonitorFactory;
        this.jabberSettings = jabberSettings;
        this.xmppActivitySupport = xmppActivitySupport;
        this.rosterListeners = new EventListenerList();
        if (configuration.getRosterListener() != null) {
            this.rosterListeners.addListener(configuration.getRosterListener());
        }
        this.rosterListeners.addListener(new EventRebroadcaster<RosterEvent>(rosterBroadcaster));
        this.friends = new TreeMap<String, XMPPFriendImpl>(String.CASE_INSENSITIVE_ORDER);
        this.smackConnectionListener = new SmackConnectionListener();
    }

    public String toString() {
        return StringUtils.toString(this, this.configuration, this.connection);
    }

    @Override
    public boolean supportsMode() {
        return true;
    }

    @Override
    public ListeningFuture<Void> setMode(final FriendPresence.Mode mode) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                XMPPFriendConnectionImpl.this.setModeImpl(mode);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setModeImpl(FriendPresence.Mode mode) throws FriendException {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            try {
                this.checkLoggedIn();
                this.connection.sendPacket(this.getPresenceForMode(mode));
            }
            catch (XMPPException e) {
                throw new FriendException(e);
            }
        }
    }

    private Packet getPresenceForMode(FriendPresence.Mode mode) {
        Presence presence = new Presence(Presence.Type.available);
        presence.setMode(Presence.Mode.valueOf(mode.name()));
        if (this.jabberSettings.advertiseLimeWireStatus()) {
            presence.setStatus("on LimeWire");
        }
        return presence;
    }

    @Override
    public FriendConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ListeningFuture<Void> login() {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                XMPPFriendConnectionImpl.this.loginImpl();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loginImpl() throws FriendException {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            try {
                this.loggingIn.set(true);
                this.connectionMulticaster.broadcast(new FriendConnectionEvent(this, FriendConnectionEvent.Type.CONNECTING));
                XMPPConnection.addConnectionCreationListener(this.smackConnectionListener);
                XMPPConnection.DEBUG_ENABLED = this.configuration.isDebugEnabled();
                this.connect();
                LOG.infof("connected.", new Object[0]);
                LOG.infof("logging in {0} with resource: {1} ...", (Object)this.configuration.getUserInputLocalID(), (Object)this.configuration.getResource());
                this.connection.login(this.configuration.getUserInputLocalID(), this.configuration.getPassword(), this.configuration.getResource());
                LOG.infof("logged in.", new Object[0]);
                this.loggedIn.set(true);
                this.loggingIn.set(false);
                this.connectionMulticaster.broadcast(new FriendConnectionEvent(this, FriendConnectionEvent.Type.CONNECTED));
            }
            catch (XMPPException e) {
                this.handleLoginError(e);
                throw new FriendException(e);
            }
            catch (RuntimeException e) {
                this.handleLoginError(e);
                throw e;
            }
        }
    }

    private synchronized void handleLoginError(Exception e) {
        this.loggingIn.set(false);
        this.connectionMulticaster.broadcast(new FriendConnectionEvent(this, FriendConnectionEvent.Type.CONNECT_FAILED, e));
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
        XMPPConnection.removeConnectionCreationListener(this.smackConnectionListener);
        this.connection = null;
    }

    private void connect() throws XMPPException {
        for (ConnectionConfigurationFactory factory : this.connectionConfigurationFactories) {
            try {
                this.connectUsingFactory(factory);
                return;
            }
            catch (FriendException e) {
                LOG.debug(e.getMessage(), e);
            }
        }
    }

    private void connectUsingFactory(ConnectionConfigurationFactory factory) throws FriendException {
        ConnectionConfigurationFactory.RequestContext requestContext = new ConnectionConfigurationFactory.RequestContext();
        while (factory.hasMore(this.configuration, requestContext)) {
            ConnectionConfiguration connectionConfig = factory.getConnectionConfiguration(this.configuration, requestContext);
            this.connection = new XMPPConnection(connectionConfig);
            this.connection.addRosterListener(new RosterListenerImpl());
            LOG.infof("connecting to {0} at {1}:{2} ...", (Object)connectionConfig.getServiceName(), (Object)connectionConfig.getHost(), (Object)connectionConfig.getPort());
            try {
                this.connection.connect();
                return;
            }
            catch (XMPPException e) {
                LOG.debug(e.getMessage(), e);
                requestContext.incrementRequests();
            }
        }
        throw new FriendException("couldn't connect using " + factory);
    }

    @Override
    public boolean isLoggingIn() {
        return this.loggingIn.get();
    }

    @Override
    public ListeningFuture<Void> logout() {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                XMPPFriendConnectionImpl.this.logoutImpl(null);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoutImpl(Exception error) {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            if (this.isLoggedIn()) {
                this.loggedIn.set(false);
                LOG.infof("disconnecting from {0} at {1}:{2} ...", (Object)this.connection.getServiceName(), (Object)this.connection.getHost(), (Object)this.connection.getPort());
                this.connection.disconnect();
                Map<String, XMPPFriendImpl> map = this.friends;
                synchronized (map) {
                    this.friends.clear();
                }
                XMPPConnection.removeConnectionCreationListener(this.smackConnectionListener);
                this.connection = null;
                LOG.info("disconnected.");
                this.connectionMulticaster.broadcast(new FriendConnectionEvent(this, FriendConnectionEvent.Type.DISCONNECTED, error));
                ChatStateManager.remove(this.connection);
                if (this.discoInfoListener != null) {
                    this.discoInfoListener.cleanup();
                }
                if (this.noSaveFeatureInitializer != null) {
                    this.noSaveFeatureInitializer.cleanup();
                }
                if (this.idleStatusMonitor != null) {
                    this.idleStatusMonitor.stop();
                }
                if (this.xmppActivityListener != null) {
                    this.xmppActivitySupport.removeListener(this.xmppActivityListener);
                }
                this.featureRegistry.deregisterInitializer(NoSaveFeature.ID);
            }
        }
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoggedIn() throws FriendException {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            if (!this.isLoggedIn()) {
                throw new FriendException("not connected");
            }
        }
    }

    @Override
    public boolean supportsAddRemoveFriend() {
        return true;
    }

    @Override
    public ListeningFuture<Void> addNewFriend(final String id, final String name) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                XMPPFriendConnectionImpl.this.addFriendImpl(id, name);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFriendImpl(String id, String name) throws FriendException {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            try {
                this.checkLoggedIn();
                Roster roster = this.connection.getRoster();
                if (roster != null) {
                    roster.createEntry(id, name, null);
                }
            }
            catch (XMPPException e) {
                throw new FriendException(e);
            }
        }
    }

    @Override
    public ListeningFuture<Void> removeFriend(final String id) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                XMPPFriendConnectionImpl.this.removeFriendImpl(id);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFriendImpl(String id) throws FriendException {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            try {
                RosterEntry entry;
                this.checkLoggedIn();
                Roster roster = this.connection.getRoster();
                if (roster != null && (entry = roster.getEntry(id)) != null) {
                    roster.removeEntry(entry);
                }
            }
            catch (XMPPException e) {
                throw new FriendException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMPPFriendImpl getFriend(String id) {
        id = PresenceUtils.parseBareAddress(id);
        Map<String, XMPPFriendImpl> map = this.friends;
        synchronized (map) {
            return this.friends.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Friend> getFriends() {
        Map<String, XMPPFriendImpl> map = this.friends;
        synchronized (map) {
            return new ArrayList<Friend>(this.friends.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws FriendException {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            try {
                this.checkLoggedIn();
                this.connection.sendPacket(packet);
            }
            catch (XMPPException e) {
                throw new FriendException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalJid() throws FriendException {
        XMPPFriendConnectionImpl xMPPFriendConnectionImpl = this;
        synchronized (xMPPFriendConnectionImpl) {
            this.checkLoggedIn();
            return this.connection.getUser();
        }
    }

    private class SmackConnectionListener
    implements ConnectionListener,
    ConnectionCreationListener {
        private SmackConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionCreated(XMPPConnection connection) {
            if (XMPPFriendConnectionImpl.this.connection != connection) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("connection created for " + connection.toString());
            }
            connection.addConnectionListener(this);
            ProviderManager providerManager = ProviderManager.getInstance();
            synchronized (providerManager) {
                if (ProviderManager.getInstance().getIQProvider("address", "jabber:iq:lw-address") == null) {
                    ProviderManager.getInstance().addIQProvider("address", "jabber:iq:lw-address", new AddressIQProvider(XMPPFriendConnectionImpl.this.addressFactory));
                }
                if (ProviderManager.getInstance().getIQProvider("file-transfer", "jabber:iq:lw-file-transfer") == null) {
                    ProviderManager.getInstance().addIQProvider("file-transfer", "jabber:iq:lw-file-transfer", FileTransferIQ.getIQProvider());
                }
                if (ProviderManager.getInstance().getIQProvider("auth-token", "jabber:iq:lw-auth-token") == null) {
                    ProviderManager.getInstance().addIQProvider("auth-token", "jabber:iq:lw-auth-token", new AuthTokenIQProvider());
                }
                if (ProviderManager.getInstance().getIQProvider("library-changed", "jabber:iq:lw-lib-change") == null) {
                    ProviderManager.getInstance().addIQProvider("library-changed", "jabber:iq:lw-lib-change", LibraryChangedIQ.getIQProvider());
                }
                if (ProviderManager.getInstance().getIQProvider("connect-back-request", "jabber:iq:lw-connect-request") == null) {
                    ProviderManager.getInstance().addIQProvider("connect-back-request", "jabber:iq:lw-connect-request", new ConnectBackRequestIQProvider());
                }
                if (ProviderManager.getInstance().getIQProvider("query", "google:nosave") == null) {
                    ProviderManager.getInstance().addIQProvider("query", "google:nosave", NoSaveIQ.getIQProvider());
                }
            }
            ChatStateManager.getInstance(connection);
            XMPPFriendConnectionImpl.this.discoInfoListener = new DiscoInfoListener(XMPPFriendConnectionImpl.this, connection, XMPPFriendConnectionImpl.this.featureRegistry);
            XMPPFriendConnectionImpl.this.discoInfoListener.addListeners(XMPPFriendConnectionImpl.this.connectionMulticaster, XMPPFriendConnectionImpl.this.friendPresenceSupport);
            XMPPFriendConnectionImpl.this.addressIQListener = XMPPFriendConnectionImpl.this.addressIQListenerFactory.create(XMPPFriendConnectionImpl.this, XMPPFriendConnectionImpl.this.addressFactory);
            connection.addPacketListener(XMPPFriendConnectionImpl.this.addressIQListener, XMPPFriendConnectionImpl.this.addressIQListener.getPacketFilter());
            XMPPFriendConnectionImpl.this.fileTransferIQListener = XMPPFriendConnectionImpl.this.fileTransferIQListenerFactory.create(XMPPFriendConnectionImpl.this);
            connection.addPacketListener(XMPPFriendConnectionImpl.this.fileTransferIQListener, XMPPFriendConnectionImpl.this.fileTransferIQListener.getPacketFilter());
            XMPPFriendConnectionImpl.this.authTokenIQListener = XMPPFriendConnectionImpl.this.authTokenIQListenerFactory.create(XMPPFriendConnectionImpl.this);
            connection.addPacketListener(XMPPFriendConnectionImpl.this.authTokenIQListener, XMPPFriendConnectionImpl.this.authTokenIQListener.getPacketFilter());
            XMPPFriendConnectionImpl.this.libraryChangedIQListener = XMPPFriendConnectionImpl.this.libraryChangedIQListenerFactory.create(XMPPFriendConnectionImpl.this);
            connection.addPacketListener(XMPPFriendConnectionImpl.this.libraryChangedIQListener, XMPPFriendConnectionImpl.this.libraryChangedIQListener.getPacketFilter());
            XMPPFriendConnectionImpl.this.connectRequestIQListener = XMPPFriendConnectionImpl.this.connectBackRequestIQListenerFactory.create(XMPPFriendConnectionImpl.this);
            connection.addPacketListener(XMPPFriendConnectionImpl.this.connectRequestIQListener, XMPPFriendConnectionImpl.this.connectRequestIQListener.getPacketFilter());
            new LimewireFeatureInitializer().register(XMPPFriendConnectionImpl.this.featureRegistry);
            XMPPFriendConnectionImpl.this.noSaveFeatureInitializer = new NoSaveFeatureInitializer(connection, XMPPFriendConnectionImpl.this, XMPPFriendConnectionImpl.this.rosterListeners, XMPPFriendConnectionImpl.this.friendPresenceSupport);
            XMPPFriendConnectionImpl.this.noSaveFeatureInitializer.register(XMPPFriendConnectionImpl.this.featureRegistry);
            SubscriptionListener sub = new SubscriptionListener(connection, XMPPFriendConnectionImpl.this.friendRequestBroadcaster);
            connection.addPacketListener(sub, sub);
            for (URI feature : XMPPFriendConnectionImpl.this.featureRegistry.getPublicFeatureUris()) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature(feature.toASCIIString());
            }
            if (XMPPFriendConnectionImpl.this.xmppActivityListener == null) {
                XMPPFriendConnectionImpl.this.xmppActivityListener = new XmppActivityEventListener();
            }
            XMPPFriendConnectionImpl.this.xmppActivitySupport.addListener(XMPPFriendConnectionImpl.this.xmppActivityListener);
            if (XMPPFriendConnectionImpl.this.idleStatusMonitor == null) {
                XMPPFriendConnectionImpl.this.idleStatusMonitor = XMPPFriendConnectionImpl.this.idleStatusMonitorFactory.create();
            }
            XMPPFriendConnectionImpl.this.idleStatusMonitor.start();
        }

        @Override
        public void connectionClosed() {
            LOG.debug("smack connection closed");
        }

        @Override
        public void connectionClosedOnError(Exception e) {
            LOG.debug("smack connection closed with error", e);
            XMPPFriendConnectionImpl.this.logoutImpl(e);
        }

        @Override
        public void reconnectingIn(int seconds) {
        }

        @Override
        public void reconnectionFailed(Exception e) {
        }

        @Override
        public void reconnectionSuccessful() {
        }
    }

    private class XmppActivityEventListener
    implements EventListener<XmppActivityEvent> {
        private XmppActivityEventListener() {
        }

        @Override
        public void handleEvent(XmppActivityEvent event) {
            switch ((XmppActivityEvent.ActivityState)((Object)event.getSource())) {
                case Idle: {
                    try {
                        XMPPFriendConnectionImpl.this.setModeImpl(FriendPresence.Mode.xa);
                    }
                    catch (FriendException e) {
                        LOG.debugf(e, "couldn't set mode based on {0}", event);
                    }
                    break;
                }
                case Active: {
                    try {
                        XMPPFriendConnectionImpl.this.setModeImpl(XMPPFriendConnectionImpl.this.jabberSettings.isDoNotDisturbSet() ? FriendPresence.Mode.dnd : FriendPresence.Mode.available);
                        break;
                    }
                    catch (FriendException e) {
                        LOG.debugf(e, "couldn't set mode based on {0}", event);
                    }
                }
            }
        }
    }

    private class RosterListenerImpl
    implements RosterListener {
        private RosterListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entriesAdded(Collection<String> addedIds) {
            try {
                XMPPFriendConnectionImpl xMPPFriendConnectionImpl = XMPPFriendConnectionImpl.this;
                synchronized (xMPPFriendConnectionImpl) {
                    XMPPFriendConnectionImpl.this.checkLoggedIn();
                    Map map = XMPPFriendConnectionImpl.this.friends;
                    synchronized (map) {
                        Roster roster = XMPPFriendConnectionImpl.this.connection.getRoster();
                        if (roster != null) {
                            HashMap<String, XMPPFriendImpl> newFriends = new HashMap<String, XMPPFriendImpl>();
                            for (String id : addedIds) {
                                RosterEntry rosterEntry = roster.getEntry(id);
                                XMPPFriendImpl friend = new XMPPFriendImpl(id, rosterEntry, XMPPFriendConnectionImpl.this.configuration, XMPPFriendConnectionImpl.this.connection, XMPPFriendConnectionImpl.this.featureRegistry);
                                LOG.debugf("user {0} added", (Object)friend);
                                newFriends.put(id, friend);
                            }
                            XMPPFriendConnectionImpl.this.friends.putAll(newFriends);
                            XMPPFriendConnectionImpl.this.rosterListeners.broadcast(new RosterEvent(new ArrayList<Friend>(newFriends.values()), RosterEvent.Type.FRIENDS_ADDED));
                        }
                    }
                }
            }
            catch (XMPPException e) {
                LOG.debugf(e, "error getting roster", new Object[0]);
            }
            catch (FriendException e) {
                LOG.debugf(e, "error getting roster", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entriesUpdated(Collection<String> updatedIds) {
            try {
                XMPPFriendConnectionImpl xMPPFriendConnectionImpl = XMPPFriendConnectionImpl.this;
                synchronized (xMPPFriendConnectionImpl) {
                    XMPPFriendConnectionImpl.this.checkLoggedIn();
                    Map map = XMPPFriendConnectionImpl.this.friends;
                    synchronized (map) {
                        Roster roster = XMPPFriendConnectionImpl.this.connection.getRoster();
                        if (roster != null) {
                            ArrayList<Friend> updatedFriends = new ArrayList<Friend>();
                            for (String id : updatedIds) {
                                RosterEntry rosterEntry = roster.getEntry(id);
                                XMPPFriendImpl friend = (XMPPFriendImpl)XMPPFriendConnectionImpl.this.friends.get(id);
                                if (friend == null) {
                                    friend = new XMPPFriendImpl(id, rosterEntry, XMPPFriendConnectionImpl.this.configuration, XMPPFriendConnectionImpl.this.connection, XMPPFriendConnectionImpl.this.featureRegistry);
                                    XMPPFriendConnectionImpl.this.friends.put(id, friend);
                                } else {
                                    friend.setRosterEntry(rosterEntry);
                                }
                                updatedFriends.add(friend);
                                LOG.debugf("user {0} updated", (Object)friend);
                            }
                            XMPPFriendConnectionImpl.this.rosterListeners.broadcast(new RosterEvent(updatedFriends, RosterEvent.Type.FRIENDS_UPDATED));
                        }
                    }
                }
            }
            catch (XMPPException e) {
                LOG.debugf(e, "error getting roster", new Object[0]);
            }
            catch (FriendException e) {
                LOG.debugf(e, "error getting roster", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entriesDeleted(Collection<String> removedIds) {
            Map map = XMPPFriendConnectionImpl.this.friends;
            synchronized (map) {
                ArrayList<Friend> deletedFriends = new ArrayList<Friend>();
                for (String id : removedIds) {
                    XMPPFriendImpl friend = (XMPPFriendImpl)XMPPFriendConnectionImpl.this.friends.remove(id);
                    if (friend == null) continue;
                    deletedFriends.add(friend);
                    LOG.debugf("user {0} removed", (Object)friend);
                }
                XMPPFriendConnectionImpl.this.rosterListeners.broadcast(new RosterEvent(deletedFriends, RosterEvent.Type.FRIENDS_DELETED));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void presenceChanged(Presence presence) {
            String localJID;
            try {
                localJID = XMPPFriendConnectionImpl.this.getLocalJid();
            }
            catch (FriendException e) {
                localJID = null;
            }
            if (!presence.getFrom().equals(localJID)) {
                XMPPFriendImpl friend = this.getFriend(presence);
                if (friend != null) {
                    LOG.debugf("presence from {0} changed to {1}", (Object)presence.getFrom(), (Object)presence.getType());
                    XMPPFriendImpl xMPPFriendImpl = friend;
                    synchronized (xMPPFriendImpl) {
                        PresenceImpl p;
                        if (presence.getType().equals((Object)Presence.Type.available)) {
                            if (!friend.getPresences().containsKey(presence.getFrom())) {
                                this.addNewPresence(friend, presence);
                            } else {
                                this.updatePresence(friend, presence);
                            }
                        } else if (presence.getType().equals((Object)Presence.Type.unavailable) && (p = (PresenceImpl)friend.getPresence(presence.getFrom())) != null) {
                            p.update(presence);
                            friend.removePresense(p);
                        }
                    }
                } else {
                    LOG.debugf("no friend for presence {0}", (Object)presence.getFrom());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XMPPFriendImpl getFriend(Presence presence) {
            XMPPFriendImpl friend;
            Map map = XMPPFriendConnectionImpl.this.friends;
            synchronized (map) {
                friend = (XMPPFriendImpl)XMPPFriendConnectionImpl.this.friends.get(PresenceUtils.parseBareAddress(presence.getFrom()));
            }
            return friend;
        }

        private void addNewPresence(XMPPFriendImpl friend, Presence presence) {
            PresenceImpl presenceImpl = new PresenceImpl(presence, friend, XMPPFriendConnectionImpl.this.featureSupport);
            presenceImpl.addTransport(AddressFeature.class, XMPPFriendConnectionImpl.this.addressIQListener);
            presenceImpl.addTransport(AuthTokenFeature.class, XMPPFriendConnectionImpl.this.authTokenIQListener);
            presenceImpl.addTransport(ConnectBackRequestFeature.class, XMPPFriendConnectionImpl.this.connectRequestIQListener);
            presenceImpl.addTransport(LibraryChangedNotifierFeature.class, XMPPFriendConnectionImpl.this.libraryChangedIQListener);
            presenceImpl.addTransport(FileOfferFeature.class, XMPPFriendConnectionImpl.this.fileTransferIQListener);
            friend.addPresense(presenceImpl);
        }

        private void updatePresence(XMPPFriendImpl friend, Presence presence) {
            PresenceImpl currentPresence = (PresenceImpl)friend.getPresences().get(presence.getFrom());
            currentPresence.update(presence);
            friend.updatePresence(currentPresence);
        }
    }
}

