/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.common;

import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Platform
extends Enum<Platform> {
    public static final /* enum */ Platform OSX;
    public static final /* enum */ Platform Linux;
    public static final /* enum */ Platform Win32;
    public static final /* enum */ Platform Solaris;
    public static final Platform platform;
    public static final String arch;
    private final String libDir;
    private static final /* synthetic */ Platform[] $VALUES;

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String name) {
        return Enum.valueOf(Platform.class, name);
    }

    private Platform(String libDir) {
        this.libDir = libDir;
    }

    public String libDir() {
        return this.libDir;
    }

    public String arch() {
        return arch;
    }

    public static boolean usingGTK2Toolkit() {
        return platform == Linux || platform == Solaris;
    }

    public static long getJavaVersion() {
        String v = System.getProperty("java.version");
        return Platform.jdkVersionToNumber(v);
    }

    public static boolean checkJavaVersion(String minVersion, String maxVersion) {
        long max;
        long min;
        long current = Platform.getJavaVersion();
        if (minVersion != null && minVersion.length() > 0 && current < (min = Platform.jdkVersionToNumber(minVersion))) {
            return false;
        }
        return maxVersion == null || maxVersion.length() <= 0 || current <= (max = Platform.jdkVersionToNumber(maxVersion));
    }

    private static long jdkVersionToNumber(String verStr) {
        try {
            String buildStr;
            String numStr;
            int idx = verStr.indexOf("_");
            if (idx >= 0) {
                numStr = verStr.substring(0, idx);
                buildStr = verStr.substring(idx + 1);
            } else {
                numStr = verStr;
                buildStr = "";
            }
            long num = 0L;
            StringTokenizer st = new StringTokenizer(numStr, ".");
            long shift = 1000000L;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int n = Integer.parseInt(s);
                num += (long)n * shift;
                shift /= 100L;
            }
            if (buildStr.startsWith("b")) {
                buildStr = buildStr.substring(1);
            }
            if (buildStr.length() > 0) {
                int n = Integer.parseInt(buildStr);
                num += (long)n;
            }
            return num;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing java version: " + verStr);
        }
    }

    static {
        String osarch;
        OSX = new Platform("macosx");
        Linux = new Platform("linux");
        Win32 = new Platform("win32");
        Solaris = new Platform("solaris");
        $VALUES = new Platform[]{OSX, Linux, Win32, Solaris};
        String osname = System.getProperty("os.name");
        platform = "Mac OS X".equals(osname) ? OSX : ("Linux".equals(osname) ? Linux : ("SunOS".equals(osname) ? Solaris : Win32));
        String archTemp = osarch = System.getProperty("os.arch");
        for (String x : new String[]{"i386", "i486", "i586", "i686"}) {
            if (!x.equals(osarch)) continue;
            archTemp = "x86";
            break;
        }
        arch = archTemp;
    }
}

