/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import java.awt.Window;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.common.Platform;
import org.mozilla.browser.test.MozillaTest;

public class DialogTest
extends MozillaTest {
    public void testAlertDirect() throws Exception {
        CloseModalDialogThread t = new CloseModalDialogThread();
        t.start();
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("alert.html")));
        t.join2();
    }

    public void testConfirmDirect() throws Exception {
        CloseModalDialogThread t = new CloseModalDialogThread();
        t.start();
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("confirm.html")));
        t.join2();
    }

    public void testPromptDirect() throws Exception {
        CloseModalDialogThread t = new CloseModalDialogThread();
        t.start();
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("prompt.html")));
        t.join2();
    }

    public void testAlertIndirect() throws Exception {
        CloseModalDialogThread t = new CloseModalDialogThread();
        t.start();
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("alert2.html")));
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(DialogTest.this.moz, "btnID"));
            }
        });
        t.join2();
    }

    public void testConfirmIndirect() throws Exception {
        CloseModalDialogThread t = new CloseModalDialogThread();
        t.start();
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("confirm2.html")));
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(DialogTest.this.moz, "btnID"));
            }
        });
        t.join2();
    }

    public void testPromptIndirect() throws Exception {
        CloseModalDialogThread t = new CloseModalDialogThread();
        t.start();
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("prompt2.html")));
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(DialogTest.this.moz, "btnID"));
            }
        });
        t.join2();
    }

    public void testRun() throws Exception {
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("download.html")));
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(DialogTest.this.moz, "linkEXE"));
            }
        });
        MozillaPanel moz = MozillaAutomation.waitForWindowWithTitle("Opening regxpcom.exe", 3000);
        DialogTest.assertNotNull((Object)moz);
        Window dlg = SwingUtilities.getWindowAncestor(moz);
        Assert.assertNotNull((Object)dlg);
        MozillaAutomation.sleep(1000);
        dlg.setVisible(false);
        dlg.dispose();
        DialogTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Opening xpcom.zip", 10000));
    }

    public void testRunSave() throws Exception {
        DialogTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, DialogTest.resolveURL("download.html")));
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(DialogTest.this.moz, "linkZIP"));
            }
        });
        MozillaPanel moz = MozillaAutomation.waitForWindowWithTitle("Opening xpcom.zip", 3000);
        DialogTest.assertNotNull((Object)moz);
        Window dlg = SwingUtilities.getWindowAncestor(moz);
        Assert.assertNotNull((Object)dlg);
        MozillaAutomation.sleep(1000);
        dlg.setVisible(false);
        dlg.dispose();
        DialogTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Opening xpcom.zip", 10000));
    }

    private class CloseModalDialogThread
    extends Thread {
        private boolean closeFailed = false;

        public CloseModalDialogThread() {
            this.setName("Close dialog");
        }

        public void run() {
            try {
                MozillaAutomation.sleep(1000);
                MozillaPanel moz = Platform.platform != Platform.OSX ? MozillaAutomation.waitForWindowWithTitle("[JavaScript Application]", 3000) : MozillaAutomation.waitForWindowWithNodeText("[JavaScript Application]", 3000);
                Assert.assertNotNull((Object)moz);
                final Window dlg = SwingUtilities.getWindowAncestor(moz);
                Assert.assertNotNull((Object)dlg);
                MozillaAutomation.sleep(1500);
                MozillaExecutor.swingSyncExec(new Runnable(){

                    public void run() {
                        dlg.setVisible(false);
                    }
                });
                MozillaTest.flushMozillaJobs();
                MozillaExecutor.swingSyncExec(new Runnable(){

                    public void run() {
                        dlg.dispose();
                    }
                });
                if (Platform.platform != Platform.OSX) {
                    Assert.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("[JavaScript Application]", 3000));
                } else {
                    Assert.assertNull((Object)MozillaAutomation.waitForNoWindowWithNodeText("[JavaScript Application]", 3000));
                }
            }
            catch (Throwable e) {
                this.closeFailed = true;
            }
        }

        public void join2() throws Exception {
            super.join();
            Assert.assertFalse((boolean)this.closeFailed);
        }
    }
}

