/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.renderer;

import com.sun.faces.renderkit.html_basic.CommandLinkRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.gui.table.component.SortableColumnHeaderComponent;
import org.rhq.core.gui.table.model.PagedListDataModel;
import org.rhq.core.gui.util.FacesComponentUtility;

public class SortableColumnHeaderRenderer
extends CommandLinkRenderer {
    private static final String BASE_IMAGE_URL = "http://127.0.0.1:7080/images";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        String sortBy = ((SortableColumnHeaderComponent)component).getSortBy();
        if (sortBy == null) {
            this.log.error((Object)("Required attribute 'sortBy' missing for " + component.getClass().getSimpleName() + " component with id" + component.getId() + " on page " + FacesContext.getCurrentInstance().getViewRoot().getViewId() + "."));
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        PageControl pageControl = this.getPageControl(component);
        boolean sortFieldFound = false;
        int orderingFieldsSize = pageControl.getOrderingFields().size();
        for (int i = 0; i < orderingFieldsSize; ++i) {
            OrderingField field = (OrderingField)pageControl.getOrderingFields().get(i);
            if (!field.getField().equals(sortBy)) continue;
            sortFieldFound = true;
            writer.startElement("img", component);
            String imageFileName = null;
            switch (field.getOrdering()) {
                case ASC: {
                    imageFileName = i == 0 ? "tb_sortup.gif" : "tb_sortup_inactive.gif";
                    break;
                }
                case DESC: {
                    imageFileName = i == 0 ? "tb_sortdown.gif" : "tb_sortdown_inactive.gif";
                }
            }
            String imageUrl = "http://127.0.0.1:7080/images/" + imageFileName;
            writer.writeAttribute("src", (Object)imageUrl, null);
            writer.writeAttribute("border", (Object)0, null);
            writer.endElement("img");
            Integer precedence = i + 1;
            writer.writeText((Object)precedence, null);
            break;
        }
        if (!sortFieldFound) {
            this.log.error((Object)("Value of attribute 'sortBy' for " + component.getClass().getSimpleName() + " component with id" + component.getId() + " on page " + FacesContext.getCurrentInstance().getViewRoot().getViewId() + " not valid for " + pageControl + "."));
        }
        super.encodeEnd(context, component);
    }

    private PageControl getPageControl(UIComponent component) {
        UIData enclosingTable = this.getEnclosingData(component);
        PagedListDataModel pagedListDataModel = (PagedListDataModel)((Object)enclosingTable.getValue());
        return pagedListDataModel.getPageControl();
    }

    private UIData getEnclosingData(UIComponent component) {
        UIData data = FacesComponentUtility.getAncestorOfType(component, UIData.class);
        if (data == null) {
            throw new IllegalStateException("No data!");
        }
        return data;
    }
}

