/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.slf4j.Logger;

public abstract class PropertySet {
    protected static final ORB sORB = ORB.init();
    protected static final PropertyError[] PROPERTY_ERROR_ARRAY_TEMPLATE = new PropertyError[0];
    protected static final PropertyRange EMPTY_PROPERTY_RANGE = new PropertyRange(sORB.create_any(), sORB.create_any());
    protected final Logger logger_ = LogUtil.getLogger(this.getClass().getName());
    private final Map listeners_ = new HashMap();
    private boolean modified_ = true;
    private final Map properties_ = new HashMap();
    private Property[] arrayView_ = null;

    public void addPropertySetListener(String[] stringArray, PropertySetListener propertySetListener) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPropertySetListener(stringArray[i], propertySetListener);
        }
    }

    public void addPropertySetListener(String string, PropertySetListener propertySetListener) {
        List<PropertySetListener> list;
        if (!this.listeners_.containsKey(string)) {
            list = new ArrayList();
            this.listeners_.put(string, list);
        } else {
            list = (List)this.listeners_.get(string);
        }
        list.add(propertySetListener);
    }

    public synchronized Property[] toArray() {
        if (this.arrayView_ == null || this.modified_) {
            Property[] propertyArray = new Property[this.properties_.size()];
            Iterator iterator = this.properties_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                propertyArray[n++] = new Property(string, (Any)this.properties_.get(string));
            }
            this.arrayView_ = propertyArray;
            this.modified_ = false;
        }
        return this.arrayView_;
    }

    public Map toMap() {
        return Collections.unmodifiableMap(this.properties_);
    }

    public String toString() {
        return this.properties_.toString();
    }

    public boolean containsKey(String string) {
        return this.properties_.containsKey(string);
    }

    public Any get(String string) {
        return (Any)this.properties_.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set_properties(Property[] propertyArray) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < propertyArray.length; ++i) {
            Any any = null;
            if (this.properties_.containsKey(propertyArray[i].name)) {
                any = (Any)this.properties_.get(propertyArray[i].name);
            }
            this.properties_.put(propertyArray[i].name, propertyArray[i].value);
            if (!this.listeners_.containsKey(propertyArray[i].name) || propertyArray[i].value.equals(any)) continue;
            hashSet.addAll((List)this.listeners_.get(propertyArray[i].name));
        }
        Object object = this;
        synchronized (object) {
            this.modified_ = true;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            try {
                ((PropertySetListener)object.next()).actionPropertySetChanged(this);
            }
            catch (Exception exception) {
                this.logger_.error("exception in listener", (Throwable)exception);
            }
        }
    }

    abstract Set getValidNames();

    protected void checkPropertyExistence(Property[] propertyArray, List list) {
        for (int i = 0; i < propertyArray.length; ++i) {
            if (this.getValidNames().contains(propertyArray[i].name)) continue;
            list.add(this.badProperty(propertyArray[i].name));
        }
    }

    protected PropertyError badProperty(String string) {
        return new PropertyError(QoSError_code.BAD_PROPERTY, string, EMPTY_PROPERTY_RANGE);
    }

    protected PropertyError badType(String string) {
        return new PropertyError(QoSError_code.BAD_TYPE, string, EMPTY_PROPERTY_RANGE);
    }

    public static Property[] map2Props(Map map) {
        Property[] propertyArray = new Property[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            propertyArray[n++] = new Property(string, (Any)map.get(string));
        }
        return propertyArray;
    }
}

