/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.BaseSecurityInfo;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.parser.AclConfigParser;
import org.jboss.security.config.parser.AuditConfigParser;
import org.jboss.security.config.parser.AuthenticationConfigParser;
import org.jboss.security.config.parser.AuthenticationJASPIConfigParser;
import org.jboss.security.config.parser.AuthorizationConfigParser;
import org.jboss.security.config.parser.IdentityTrustConfigParser;
import org.jboss.security.config.parser.MappingConfigParser;
import org.jboss.security.config.parser.StaxParserUtil;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPolicyParser {
    public List<ApplicationPolicy> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        ArrayList<ApplicationPolicy> policies = new ArrayList<ApplicationPolicy>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            int eventType = xmlEvent.getEventType();
            switch (eventType) {
                case 1: {
                    StartElement appPolicyElement = (StartElement)xmlEvent;
                    if (!"application-policy".equals(StaxParserUtil.getStartElementName(appPolicyElement))) {
                        throw new RuntimeException("<application-policy> element expected at " + StaxParserUtil.getLineColumnNumber(xmlEvent.getLocation()));
                    }
                    Iterator<Attribute> attrs = appPolicyElement.getAttributes();
                    String extendsName = null;
                    String appPolicyName = null;
                    while (attrs.hasNext()) {
                        Attribute attribute = attrs.next();
                        QName attributeName = attribute.getName();
                        String attributeValue = StaxParserUtil.getAttributeValue(attribute);
                        if ("name".equals(attributeName.getLocalPart())) {
                            appPolicyName = attributeValue;
                            continue;
                        }
                        if (!"extends".equals(attributeName.getLocalPart())) continue;
                        extendsName = attributeValue;
                    }
                    ApplicationPolicy applicationPolicy = new ApplicationPolicy(appPolicyName);
                    if (extendsName != null) {
                        applicationPolicy.setBaseApplicationPolicyName(extendsName);
                    }
                    this.route(xmlEventReader, applicationPolicy);
                    policies.add(applicationPolicy);
                }
            }
        }
        return policies;
    }

    private void route(XMLEventReader xmlEventReader, ApplicationPolicy appPolicy) throws XMLStreamException {
        String elementName;
        XMLEvent xmlEvent;
        block0: while (true) {
            BaseSecurityInfo authInfo;
            Collection<Object> entries;
            Object parser;
            if ((xmlEvent = xmlEventReader.peek()) == null) {
                return;
            }
            StartElement startElement = xmlEvent.asStartElement();
            elementName = StaxParserUtil.getStartElementName(startElement);
            if ("authentication".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuthenticationConfigParser();
                entries = ((AuthenticationConfigParser)parser).parse(xmlEventReader);
                authInfo = new AuthenticationInfo();
                ((AuthenticationInfo)authInfo).setAppConfigurationEntry(new ArrayList<AppConfigurationEntry>(entries));
                appPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authInfo);
                continue;
            }
            if ("authentication-jaspi".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuthenticationJASPIConfigParser();
                JASPIAuthenticationInfo authInfo2 = ((AuthenticationJASPIConfigParser)parser).parse(xmlEventReader);
                appPolicy.setAuthenticationInfo(authInfo2);
                continue;
            }
            if ("authorization".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuthorizationConfigParser();
                entries = ((AuthorizationConfigParser)parser).parse(xmlEventReader);
                authInfo = new AuthorizationInfo(appPolicy.getName());
                authInfo.add(new ArrayList<AppConfigurationEntry>(entries));
                appPolicy.setAuthorizationInfo((AuthorizationInfo)authInfo);
                continue;
            }
            if ("acl".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AclConfigParser();
                entries = ((AclConfigParser)parser).parse(xmlEventReader);
                ACLInfo aclInfo = new ACLInfo(appPolicy.getName());
                aclInfo.add(new ArrayList<Object>(entries));
                appPolicy.setAclInfo(aclInfo);
                continue;
            }
            if ("rolemapping".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new MappingConfigParser();
                entries = ((MappingConfigParser)parser).parse(xmlEventReader);
                MappingInfo mappingInfo = new MappingInfo(appPolicy.getName());
                mappingInfo.add(entries);
                appPolicy.setMappingInfo(MappingType.ROLE.toString(), mappingInfo);
                continue;
            }
            if ("mapping".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new MappingConfigParser();
                entries = ((MappingConfigParser)parser).parse(xmlEventReader);
                Iterator i$ = entries.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    MappingModuleEntry entry = (MappingModuleEntry)i$.next();
                    MappingInfo mappingInfo = new MappingInfo(appPolicy.getName());
                    mappingInfo.add(entry);
                    String moduleType = entry.getMappingModuleType();
                    appPolicy.setMappingInfo(moduleType, mappingInfo);
                }
            }
            if ("audit".equals(elementName)) {
                xmlEvent = xmlEventReader.nextEvent();
                parser = new AuditConfigParser();
                entries = ((AuditConfigParser)parser).parse(xmlEventReader);
                authInfo = new AuditInfo(appPolicy.getName());
                authInfo.add(entries);
                appPolicy.setAuditInfo((AuditInfo)authInfo);
                continue;
            }
            if (!"identity-trust".equals(elementName)) break;
            xmlEvent = xmlEventReader.nextEvent();
            parser = new IdentityTrustConfigParser();
            entries = ((IdentityTrustConfigParser)parser).parse(xmlEventReader);
            authInfo = new IdentityTrustInfo(appPolicy.getName());
            authInfo.add(entries);
            appPolicy.setIdentityTrustInfo((IdentityTrustInfo)authInfo);
        }
        if (!"application-policy".equals(elementName)) {
            throw new RuntimeException("Unknown element " + elementName + " at location " + StaxParserUtil.getLineColumnNumber(xmlEvent.getLocation()));
        }
    }
}

