/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert.seamtext.tags;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.richfaces.convert.seamtext.tags.EmptyHtmlTag;
import org.richfaces.convert.seamtext.tags.FormattingTag;
import org.richfaces.convert.seamtext.tags.HtmlTag;
import org.richfaces.convert.seamtext.tags.LineTag;
import org.richfaces.convert.seamtext.tags.LinkTag;
import org.richfaces.convert.seamtext.tags.OrderedListTag;
import org.richfaces.convert.seamtext.tags.ParagraphTag;
import org.richfaces.convert.seamtext.tags.RootTag;
import org.richfaces.convert.seamtext.tags.UnorderedListTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagFactory {
    public static final String SEAM_PLUS = "+";
    public static final String SEAM_MONOSPACE = "|";
    public static final String SEAM_TWIDDLE = "~";
    public static final String SEAM_HASH = "#";
    public static final String SEAM_HAT = "^";
    public static final String SEAM_STAR = "*";
    public static final String SEAM_UNDERSCORE = "_";
    public static final String SEAM_EQ = "=";
    public static final String SEAM_BACKTICK = "`";
    public static final String SEAM_DOUBLEQUOTE = "\"";
    public static final String SEAM_LINK_START = "[";
    public static final String SEAM_LINK_END = "]";
    private static final Collection<HtmlTag> TAGS = Arrays.asList(new RootTag(), new EmptyHtmlTag("hr"), new EmptyHtmlTag("br"), new EmptyHtmlTag("img"), new EmptyHtmlTag("area"), new EmptyHtmlTag("col"), new LineTag("h1", "+ "), new LineTag("h2", "++ "), new LineTag("h3", "+++ "), new LineTag("h4", "++++ "), new LineTag("li", ""){

        public String printBody() {
            if (this.isBodyEmpty() && !this.isHtml) {
                return " ";
            }
            if (!this.body.isEmpty() && this.body.get(0) instanceof HtmlTag) {
                this.body.add(0, " ");
            }
            return super.printBody();
        }
    }, new ParagraphTag(), new FormattingTag("i", "*"), new FormattingTag("del", "~"), new FormattingTag("sup", "^"), new FormattingTag("u", "_"), new FormattingTag("tt", "|"){

        public boolean isFormating() {
            return true;
        }
    }, TagFactory.getNewTagDefinition("q", "\"", "\""), new LinkTag(), new UnorderedListTag(), new OrderedListTag());
    private static final Map<String, HtmlTag> TAGS_MAP = new HashMap<String, HtmlTag>(TAGS.size());

    private static HtmlTag getNewTagDefinition(String tagName, final String startTag, final String endTag) {
        return new HtmlTag(tagName){

            public String printStart() {
                return startTag;
            }

            public String printEnd() {
                return endTag;
            }

            public String printStartSuffix() {
                return "";
            }
        };
    }

    public HtmlTag getInstance(String tagName) {
        return this.getInstance(tagName, null);
    }

    public HtmlTag getInstance(String tagName, Map<String, String> attr) {
        HtmlTag tag = TAGS_MAP.get(tagName);
        tag = tag == null ? new HtmlTag(tagName) : tag.cloneTag();
        tag.setAttributes(attr);
        return tag;
    }

    static {
        for (HtmlTag tag : TAGS) {
            TAGS_MAP.put(tag.getName(), tag);
        }
    }
}

