/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.joinpoint.Joinpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinPointInfo
implements JoinPointBean {
    private ReentrantReadWriteLock interceptorChainLock = new ReentrantReadWriteLock();
    public Interceptor[] interceptors;
    private ArrayList<Interceptor> interceptorChain = new ArrayList();
    private WeakReference<Advisor> advisor;
    protected volatile Joinpoint joinpoint;
    protected WeakReference<Class<?>> clazz;
    private String adviceString;

    protected JoinPointInfo() {
        this.clazz = new WeakReference<Object>(null);
    }

    protected JoinPointInfo(Advisor advisor, Class<?> clazz) {
        this.clazz = new WeakReference(clazz);
        this.setAdvisor(advisor);
    }

    protected JoinPointInfo(JoinPointInfo other) {
        this.advisor = other.advisor;
        this.clazz = other.clazz;
        if (other.interceptors != null) {
            this.interceptors = new Interceptor[other.interceptors.length];
            System.arraycopy(other.interceptors, 0, this.interceptors, 0, other.interceptors.length);
        }
        if (other.interceptorChain != null) {
            this.interceptorChain.addAll(this.interceptorChain);
        }
    }

    protected void clear() {
        this.interceptorChain.clear();
        this.interceptors = null;
        this.interceptors = new Interceptor[0];
    }

    protected void resetChainKeepInterceptors() {
        this.interceptorChain.clear();
    }

    protected void resetInterceptors() {
        this.interceptors = new Interceptor[0];
    }

    @Override
    public Advisor getAdvisor() {
        if (this.advisor == null) {
            return null;
        }
        return (Advisor)this.advisor.get();
    }

    @Override
    public Class<?> getClazz() {
        return (Class)this.clazz.get();
    }

    public void setAdvisor(Advisor advisor) {
        this.advisor = new WeakReference<Advisor>(advisor);
        if (this.getClazz() == null && advisor != null) {
            this.clazz = new WeakReference<Class>(advisor.getClazz());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAdvices() {
        this.interceptorChainLock.readLock().lock();
        try {
            boolean bl = this.interceptors != null && this.interceptors.length > 0;
            return bl;
        }
        finally {
            this.interceptorChainLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equalChains(Interceptor[] otherInterceptors) {
        this.interceptorChainLock.readLock().lock();
        try {
            if (this.interceptors == null && otherInterceptors == null) {
                boolean bl = true;
                return bl;
            }
            if (this.interceptors == null || otherInterceptors == null) {
                boolean bl = false;
                return bl;
            }
            if (this.interceptors.length != otherInterceptors.length) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < this.interceptors.length; ++i) {
                if (this.interceptors[i].equals(otherInterceptors[i])) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.interceptorChainLock.readLock().unlock();
        }
    }

    public Joinpoint getJoinpoint() {
        if (this.joinpoint == null) {
            this.joinpoint = this.internalGetJoinpoint();
        }
        return this.joinpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Interceptor> getInterceptorChain() {
        this.interceptorChainLock.readLock().lock();
        try {
            ArrayList<Interceptor> arrayList = this.interceptorChain;
            return arrayList;
        }
        finally {
            this.interceptorChainLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interceptor[] getInterceptors() {
        this.interceptorChainLock.readLock().lock();
        try {
            Interceptor[] interceptorArray = this.interceptors;
            return interceptorArray;
        }
        finally {
            this.interceptorChainLock.readLock().unlock();
        }
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptorChainLock.writeLock().lock();
        this.adviceString = null;
        this.interceptors = interceptors;
        this.interceptorChainLock.writeLock().unlock();
    }

    protected abstract Joinpoint internalGetJoinpoint();

    public abstract JoinPointInfo copy();

    @Override
    public Object resolveClassMetaData(Object key, Object attr) {
        return this.getAdvisor().getClassMetaData().getMetaData(key, attr);
    }

    @Override
    public <T extends Annotation> T resolveClassAnnotation(Class<T> annotation) {
        Advisor advisor = this.getAdvisor();
        if (advisor != null) {
            return advisor.resolveTypedAnnotation(annotation);
        }
        return null;
    }

    @Override
    public <T extends Annotation> T resolveAnnotation(Class<T> annotation) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneChains(JoinPointInfo other) {
        this.interceptorChainLock.writeLock().lock();
        other.interceptorChainLock.readLock().lock();
        try {
            this.interceptorChain = (ArrayList)other.interceptorChain.clone();
            this.interceptors = other.interceptors == null ? null : (Interceptor[])other.interceptors.clone();
        }
        finally {
            this.interceptorChainLock.writeLock().unlock();
            other.interceptorChainLock.readLock().unlock();
        }
    }

    public String getAdviceString() {
        if (this.adviceString == null) {
            if (this.interceptors == null || this.interceptors.length == 0) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.interceptors.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                GeneratedAdvisorInterceptor icptr = (GeneratedAdvisorInterceptor)this.interceptors[i];
                buf.append(icptr.getAdviceString());
            }
            return buf.toString();
        }
        return this.adviceString;
    }

    public final ReentrantReadWriteLock getInterceptorChainReadWriteLock() {
        return this.interceptorChainLock;
    }
}

