/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.config;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.settings.impl.AddressSettings;

public class PersistedAddressSetting
implements EncodingSupport {
    private long storeId;
    private SimpleString addressMatch;
    private AddressSettings setting;

    public PersistedAddressSetting() {
    }

    public PersistedAddressSetting(SimpleString addressMatch, AddressSettings setting) {
        this.addressMatch = addressMatch;
        this.setting = setting;
    }

    public void setStoreId(long id) {
        this.storeId = id;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public SimpleString getAddressMatch() {
        return this.addressMatch;
    }

    public AddressSettings getSetting() {
        return this.setting;
    }

    @Override
    public void decode(HornetQBuffer buffer) {
        this.addressMatch = buffer.readSimpleString();
        this.setting = new AddressSettings();
        this.setting.decode(buffer);
    }

    @Override
    public void encode(HornetQBuffer buffer) {
        buffer.writeSimpleString(this.addressMatch);
        this.setting.encode(buffer);
    }

    @Override
    public int getEncodeSize() {
        return this.addressMatch.sizeof() + this.setting.getEncodeSize();
    }
}

