/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.CustomScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.NamedEvent;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.validator.FacesValidator;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.NamedEventManager;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation._ClassByteCodeAnnotationFilter;
import org.apache.myfaces.config.annotation._PackageInfo;
import org.apache.myfaces.config.impl.digester.elements.FacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.view.facelets.util.Classpath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigurator {
    private static final Logger log = Logger.getLogger(AnnotationConfigurator.class.getName());
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "META-INF/standard-faces-config.xml";
    public static final String SCAN_PACKAGES = "org.apache.myfaces.annotation.SCAN_PACKAGES";
    private static final String FACES_CONFIG_DEFAULT = "/WEB-INF/faces-config.xml";
    private static final String FACES_CONFIG_IMPLICIT = "META-INF/faces-config.xml";
    private static final String WEB_CLASSES_PREFIX = "/WEB-INF/classes/";
    private static final String WEB_LIB_PREFIX = "/WEB-INF/lib/";
    private final ExternalContext _externalContext;
    private final _ClassByteCodeAnnotationFilter _filter;
    private static Set<String> byteCodeAnnotationsNames;
    private RenderKitFactory rkFactory = null;

    public AnnotationConfigurator(ExternalContext externalContext) {
        this._externalContext = externalContext;
        this._filter = new _ClassByteCodeAnnotationFilter();
    }

    public void configure(Application application, FacesConfigDispenser<FacesConfig> dispenser, boolean metadataComplete) throws FacesException {
        List<Class> classes;
        List<JarFile> archives = null;
        if (!metadataComplete) {
            String scanPackages = this._externalContext.getInitParameter(SCAN_PACKAGES);
            if (scanPackages != null) {
                try {
                    classes = this.packageClasses(this._externalContext, scanPackages);
                }
                catch (ClassNotFoundException e) {
                    throw new FacesException((Throwable)e);
                }
                catch (IOException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            try {
                classes = this.webClasses(this._externalContext);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException((Throwable)e);
            }
            try {
                for (Class clazz : classes) {
                    this.configureClass(application, dispenser, clazz);
                }
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            try {
                archives = this.webArchives(this._externalContext);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Receiving " + archives.size() + " jar files to check");
                }
                for (JarFile archive : archives) {
                    classes = this.archiveClasses(this._externalContext, archive);
                    for (Class clazz : classes) {
                        this.configureClass(application, dispenser, clazz);
                    }
                }
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        try {
            JarFile jarFile = this.getMyfacesImplJarFile();
            if (jarFile != null) {
                classes = this.archiveClasses(this._externalContext, jarFile);
                for (Class clazz : classes) {
                    this.configureClass(application, dispenser, clazz);
                }
            }
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private JarFile getMyfacesImplJarFile() throws IOException {
        URL url = this.getClassLoader().getResource(STANDARD_FACES_CONFIG_RESOURCE);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(STANDARD_FACES_CONFIG_RESOURCE);
        }
        return this.getJarFile(url);
    }

    private JarFile getJarFile(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        JarFile jarFile = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFile() : AnnotationConfigurator._getAlternativeJarFile(url);
        return jarFile;
    }

    private List<Class> packageClasses(ExternalContext externalContext, String scanPackages) throws ClassNotFoundException, IOException {
        String[] scanPackageTokens;
        ArrayList<Class> list = new ArrayList<Class>();
        for (String scanPackageToken : scanPackageTokens = scanPackages.split(",")) {
            if (scanPackageToken.toLowerCase().endsWith(".jar")) {
                URL jarResource = externalContext.getResource(WEB_LIB_PREFIX + scanPackageToken);
                String jarURLString = "jar:" + jarResource.toString() + "!/";
                URL url = new URL(jarURLString);
                JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                list.addAll(this.archiveClasses(externalContext, jarFile));
                continue;
            }
            _PackageInfo.getInstance().getClasses(list, scanPackageToken);
        }
        return list;
    }

    private List<JarFile> webArchives(ExternalContext externalContext) throws IOException {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        Set paths = externalContext.getResourcePaths(WEB_LIB_PREFIX);
        if (paths == null || paths.isEmpty()) {
            Iterator it = ClassUtils.getResources(FACES_CONFIG_IMPLICIT, this);
            while (it.hasNext()) {
                URL url = (URL)it.next();
                JarFile jarFile = this.getJarFile(url);
                if (jarFile == null) continue;
                list.add(jarFile);
            }
            URL[] urls = Classpath.search(this.getClassLoader(), META_INF_PREFIX, FACES_CONFIG_SUFFIX);
            for (int i = 0; i < urls.length; ++i) {
                JarFile jarFile = this.getJarFile(urls[i]);
                if (jarFile == null) continue;
                list.add(jarFile);
            }
        } else {
            for (String pathObject : paths) {
                String path = pathObject;
                if (!path.endsWith(".jar")) continue;
                URL url = externalContext.getResource(path);
                String jarURLString = "jar:" + url.toString() + "!/";
                url = new URL(jarURLString);
                JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                JarEntry signal = jarFile.getJarEntry(FACES_CONFIG_IMPLICIT);
                if (signal == null) {
                    Enumeration<JarEntry> e = jarFile.entries();
                    while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith(META_INF_PREFIX) || !name.endsWith(FACES_CONFIG_SUFFIX)) continue;
                        signal = entry;
                        break;
                    }
                }
                if (signal == null) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("Skip JAR file " + path + " because it has no META-INF/faces-config.xml resource");
                    continue;
                }
                list.add(jarFile);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class> archiveClasses(ExternalContext context, JarFile jar) throws ClassNotFoundException {
        ArrayList<Class> list = new ArrayList<Class>();
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || (name = entry.getName()).startsWith(META_INF_PREFIX) || !name.endsWith(".class")) continue;
            DataInputStream in = null;
            boolean couldContainAnnotation = false;
            try {
                in = new DataInputStream(jar.getInputStream(entry));
                couldContainAnnotation = this._filter.couldContainAnnotationsOnClassDef(in, byteCodeAnnotationsNames);
            }
            catch (IOException e) {
                couldContainAnnotation = true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IOException when filtering class " + name + " for annotations");
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (!couldContainAnnotation) continue;
            name = name.substring(0, name.length() - 6);
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(name.replace('/', '.'));
            }
            catch (NoClassDefFoundError e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            if (clazz == null) continue;
            list.add(clazz);
        }
        return list;
    }

    private List<Class> webClasses(ExternalContext externalContext) throws ClassNotFoundException {
        ArrayList<Class> list = new ArrayList<Class>();
        this.webClasses(externalContext, WEB_CLASSES_PREFIX, list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void webClasses(ExternalContext externalContext, String prefix, List<Class> list) throws ClassNotFoundException {
        ClassLoader loader = this.getClassLoader();
        Set paths = externalContext.getResourcePaths(prefix);
        if (paths == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("webClasses(" + prefix + ") - Received " + paths.size() + " paths to check");
        }
        String path = null;
        if (paths.isEmpty()) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("AnnotationConfigurator does not found classes for annotations in " + prefix + " ." + " This could happen because maven jetty plugin is used" + " (goal jetty:run). Try configure " + SCAN_PACKAGES + " init parameter " + "or use jetty:run-exploded instead.");
            }
        } else {
            for (String pathObject : paths) {
                path = pathObject;
                if (path.endsWith("/")) {
                    this.webClasses(externalContext, path, list);
                    continue;
                }
                if (!path.endsWith(".class")) continue;
                DataInputStream in = null;
                boolean couldContainAnnotation = false;
                try {
                    in = new DataInputStream(externalContext.getResourceAsStream(path));
                    couldContainAnnotation = this._filter.couldContainAnnotationsOnClassDef(in, byteCodeAnnotationsNames);
                }
                catch (IOException e) {
                    couldContainAnnotation = true;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("IOException when filtering class " + path + " for annotations");
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (!couldContainAnnotation) continue;
                path = path.substring(WEB_CLASSES_PREFIX.length());
                path = path.substring(0, path.length() - 6);
                path = path.replace('/', '.');
                Class<?> clazz = null;
                try {
                    clazz = loader.loadClass(path);
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (clazz == null) continue;
                list.add(clazz);
            }
        }
    }

    protected void configureClass(Application application, FacesConfigDispenser<FacesConfig> dispenser, Class clazz) {
        FacesBehaviorRenderer facesBehaviorRenderer;
        FacesBehavior facesBehavior;
        NamedEvent namedEvent;
        ManagedBean bean;
        FacesRenderer rend;
        FacesValidator val;
        FacesConverter conv;
        FacesComponent comp;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("registerClass(" + clazz.getName() + ")");
        }
        if ((comp = clazz.getAnnotation(FacesComponent.class)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addComponent(" + comp.value() + "," + clazz.getName() + ")");
            }
            if (dispenser.getComponentClass(comp.value()) == null) {
                application.addComponent(comp.value(), clazz.getName());
            }
        }
        if ((conv = clazz.getAnnotation(FacesConverter.class)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addConverter(" + conv.value() + "," + clazz.getName() + ")");
            }
            if (!Object.class.equals((Object)conv.forClass())) {
                application.addConverter(conv.forClass(), clazz.getName());
            }
            if (dispenser.getConverterClassById(conv.value()) == null && conv.value() != null && !"".equals(conv.value())) {
                application.addConverter(conv.value(), clazz.getName());
            }
        }
        if ((val = clazz.getAnnotation(FacesValidator.class)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addValidator(" + val.value() + "," + clazz.getName() + ")");
            }
            if (dispenser.getValidatorClass(val.value()) == null) {
                application.addValidator(val.value(), clazz.getName());
                if (val.isDefault()) {
                    application.addDefaultValidatorId(val.value());
                }
            }
        }
        if ((rend = clazz.getAnnotation(FacesRenderer.class)) != null) {
            String renderKitId = rend.renderKitId();
            if (renderKitId == null) {
                renderKitId = "HTML_BASIC";
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addRenderer(" + renderKitId + ", " + rend.componentFamily() + ", " + rend.rendererType() + ", " + clazz.getName() + ")");
            }
            try {
                RenderKit rk = this.renderKitFactory().getRenderKit(null, renderKitId);
                if (rk == null) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.severe("RenderKit " + renderKitId + " not found when adding @FacesRenderer annotation");
                    }
                    throw new FacesException("RenderKit " + renderKitId + " not found when adding @FacesRenderer annotation");
                }
                rk.addRenderer(rend.componentFamily(), rend.rendererType(), (Renderer)clazz.newInstance());
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        if ((bean = clazz.getAnnotation(ManagedBean.class)) != null) {
            Field[] fields;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Class '" + clazz.getName() + "' has an @ManagedBean annotation");
            }
            RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
            org.apache.myfaces.config.impl.digester.elements.ManagedBean mbc = new org.apache.myfaces.config.impl.digester.elements.ManagedBean();
            String beanName = bean.name();
            if (beanName == null || beanName.equals("")) {
                beanName = clazz.getName();
                int index = beanName.lastIndexOf(".");
                if (index != -1) {
                    beanName = beanName.substring(index + 1);
                }
                beanName = Character.toLowerCase(beanName.charAt(0)) + beanName.substring(1);
            }
            mbc.setName(beanName);
            mbc.setBeanClass(clazz.getName());
            ApplicationScoped appScoped = clazz.getAnnotation(ApplicationScoped.class);
            if (appScoped != null) {
                mbc.setScope("application");
            } else {
                NoneScoped noneScoped = clazz.getAnnotation(NoneScoped.class);
                if (noneScoped != null) {
                    mbc.setScope("none");
                } else {
                    RequestScoped requestScoped = clazz.getAnnotation(RequestScoped.class);
                    if (requestScoped != null) {
                        mbc.setScope("request");
                    } else {
                        SessionScoped sessionScoped = clazz.getAnnotation(SessionScoped.class);
                        if (sessionScoped != null) {
                            mbc.setScope("session");
                        } else {
                            ViewScoped viewScoped = clazz.getAnnotation(ViewScoped.class);
                            if (viewScoped != null) {
                                mbc.setScope("view");
                            } else {
                                CustomScoped customScoped = clazz.getAnnotation(CustomScoped.class);
                                if (customScoped != null) {
                                    mbc.setScope(customScoped.value());
                                } else {
                                    mbc.setScope("request");
                                }
                            }
                        }
                    }
                }
            }
            for (Field field : fields = this.fields(clazz)) {
                ManagedProperty property;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("  Scanning field '" + field.getName() + "'");
                }
                if ((property = field.getAnnotation(ManagedProperty.class)) == null) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("  Field '" + field.getName() + "' has a @ManagedProperty annotation");
                }
                org.apache.myfaces.config.impl.digester.elements.ManagedProperty mpc = new org.apache.myfaces.config.impl.digester.elements.ManagedProperty();
                String name = property.name();
                if (name == null || "".equals(name)) {
                    name = field.getName();
                }
                mpc.setPropertyName(name);
                mpc.setPropertyClass(field.getType().getName());
                mpc.setValue(property.value());
                mbc.addProperty(mpc);
            }
            runtimeConfig.addManagedBean(mbc.getManagedBeanName(), mbc);
        }
        if ((namedEvent = clazz.getAnnotation(NamedEvent.class)) != null) {
            if (!ComponentSystemEvent.class.isAssignableFrom(clazz)) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning(clazz.getName() + " is annotated with @javax.faces.event.NamedEvent, but does " + "not extend javax.faces.event.ComponentSystemEvent");
                }
                return;
            }
            NamedEventManager.getInstance().addNamedEvent(namedEvent.shortName(), clazz);
        }
        if ((facesBehavior = clazz.getAnnotation(FacesBehavior.class)) != null) {
            if (!Behavior.class.isAssignableFrom(clazz) && log.isLoggable(Level.WARNING)) {
                log.warning(clazz.getName() + " is annotated with @javax.faces.component.behavior.FacesBehavior, " + "but does not implement javax.faces.component.behavior.Behavior");
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addBehavior(" + facesBehavior.value() + ", " + clazz.getName() + ")");
            }
            application.addBehavior(facesBehavior.value(), clazz.getName());
        }
        if ((facesBehaviorRenderer = clazz.getAnnotation(FacesBehaviorRenderer.class)) != null) {
            String renderKitId = facesBehaviorRenderer.renderKitId();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addClientBehaviorRenderer(" + renderKitId + ", " + facesBehaviorRenderer.rendererType() + ", " + clazz.getName() + ")");
            }
            try {
                RenderKit renderKit = this.renderKitFactory().getRenderKit(null, renderKitId);
                ClientBehaviorRenderer clientBehaviorRenderer = (ClientBehaviorRenderer)clazz.newInstance();
                renderKit.addClientBehaviorRenderer(facesBehaviorRenderer.rendererType(), clientBehaviorRenderer);
            }
            catch (Throwable e) {
                throw new FacesException(e);
            }
        }
    }

    private Field[] fields(Class clazz) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return fields.values().toArray(new Field[fields.size()]);
    }

    private RenderKitFactory renderKitFactory() {
        if (this.rkFactory == null) {
            this.rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this.rkFactory;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }

    private static JarFile _getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    static {
        HashSet<String> bcan = new HashSet<String>(10, 1.0f);
        bcan.add("Ljavax/faces/component/FacesComponent;");
        bcan.add("Ljavax/faces/component/behavior/FacesBehavior;");
        bcan.add("Ljavax/faces/convert/FacesConverter;");
        bcan.add("Ljavax/faces/validator/FacesValidator;");
        bcan.add("Ljavax/faces/render/FacesRenderer;");
        bcan.add("Ljavax/faces/bean/ManagedBean;");
        bcan.add("Ljavax/faces/event/NamedEvent;");
        bcan.add("Ljavax/faces/render/FacesBehaviorRenderer;");
        byteCodeAnnotationsNames = Collections.unmodifiableSet(bcan);
    }
}

