/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.httpserver;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.jboss.ws.httpserver_httpspi.PathUtils;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerEngineFactory;

public class HttpServerEngine {
    private static final Logger LOG = LogUtils.getL7dLogger(HttpServerEngine.class);
    private static final int DELAY = Integer.getInteger(System.getProperty(HttpServerEngineFactory.class.getName() + ".STOP_DELAY"), 1);
    private static final int BACKLOG = 0;
    private Bus bus;
    private HttpServerEngineFactory factory;
    private String host;
    private int port;
    private int handlerCount;
    private String protocol = "http";
    private HttpServer server;

    public HttpServerEngine(HttpServerEngineFactory fac, Bus bus, String host, int port) {
        this.bus = bus;
        this.factory = fac;
        this.host = host;
        this.port = port;
    }

    public Bus getBus() {
        return this.bus;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public synchronized void addHandler(String address, HttpHandler handler) {
        if (this.server == null) {
            InetSocketAddress isa = this.host != null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.port);
            try {
                this.server = HttpServer.create(isa, 0);
                this.server.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.server.createContext(PathUtils.getContextPath((String)address) + PathUtils.getPath((String)address), handler);
        ++this.handlerCount;
    }

    public synchronized void removeHandler(String address) {
        this.server.removeContext(PathUtils.getContextPath((String)address) + PathUtils.getPath((String)address));
        --this.handlerCount;
    }

    protected void stop() throws Exception {
        if (this.server != null) {
            this.server.stop(DELAY);
        }
    }

    public void shutdown() {
        if (this.factory != null && this.handlerCount == 0) {
            this.factory.destroyForPort(this.port);
        } else {
            LOG.log(Level.WARNING, "FAILED_TO_SHUTDOWN_ENGINE_MSG", this.port);
        }
    }
}

