/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.group;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CombinedIterator<E>
implements Iterator<E> {
    private final Iterator<E> i1;
    private final Iterator<E> i2;
    private Iterator<E> currentIterator;

    CombinedIterator(Iterator<E> i1, Iterator<E> i2) {
        if (i1 == null) {
            throw new NullPointerException("i1");
        }
        if (i2 == null) {
            throw new NullPointerException("i2");
        }
        this.i1 = i1;
        this.i2 = i2;
        this.currentIterator = i1;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.currentIterator.hasNext();
        if (hasNext) {
            return true;
        }
        if (this.currentIterator == this.i1) {
            this.currentIterator = this.i2;
            return this.hasNext();
        }
        return false;
    }

    @Override
    public E next() {
        try {
            E e = this.currentIterator.next();
            return e;
        }
        catch (NoSuchElementException e) {
            if (this.currentIterator == this.i1) {
                this.currentIterator = this.i2;
                return this.next();
            }
            throw e;
        }
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }
}

