/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.jaspi.modules;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Class<?> loadClass(final String fqn) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws Exception {
                ClassLoader tcl = SecurityActions.getContextClassLoader();
                return tcl.loadClass(fqn);
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setSystemProperty(final String key, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty(key, value);
                return null;
            }
        });
    }
}

