/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.persistent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;
import org.jboss.web.tomcat.service.session.persistent.IncomingDistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.persistent.PersistentStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RDBMSStoreBase
implements PersistentStore {
    private static final Logger LOG = Logger.getLogger(RDBMSStoreBase.class);
    public static final String DEFAULT_TABLE = "httpsessions";
    public static final String DEFAULT_APP_COL = "app";
    public static final String DEFAULT_ID_COL = "id";
    public static final String DEFAULT_FULLID_COL = "fullid";
    public static final String DEFAULT_ATTRIBUTE_COL = "attributes";
    public static final String DEFAULT_METADATA_COL = "metadata";
    public static final String DEFAULT_ISNEW_COL = "isnew";
    public static final String DEFAULT_ISVALID_COL = "valid";
    public static final String DEFAULT_CREATION_TIME_COL = "creationtime";
    public static final String DEFAULT_LAST_ACCESSED_COL = "lastaccess";
    public static final String DEFAULT_MAX_INACTIVE_COL = "maxinactive";
    public static final String DEFAULT_VERSION_COL = "version";
    public static final int DEFAULT_CLEANUP_INTERVAL = 14400;
    private Logger logger = null;
    private boolean started = false;
    private String name = null;
    private int cleanupInterval = 14400;
    private long lastCleanup = 0L;
    private int maxUnreplicatedInterval = -1;
    private String connectionName = null;
    private String connectionPassword = null;
    private String sessionTable = "httpsessions";
    private String sessionAppCol = "app";
    private String sessionIdCol = "id";
    private String sessionFullIdCol = "fullid";
    private String sessionCreationTimeCol = "creationtime";
    private String sessionMaxInactiveCol = "maxinactive";
    private String sessionVersionCol = "version";
    private String sessionLastAccessedCol = "lastaccess";
    private String sessionNewCol = "isnew";
    private String sessionValidCol = "valid";
    private String sessionMetadataCol = "metadata";
    private String sessionAttributeCol = "attributes";
    private String clearSql;
    private String sizeSql;
    private String insertSql;
    private String fullUpdateSql;
    private String keysSql;
    private String fullLoadSql;
    private String partialLoadSql;
    private String reinsertSql;
    private String removeSql;
    private String versionSql;
    private String timestampSql;
    private final Map<Connection, Set<Statement>> statementsByConnection = new ConcurrentHashMap<Connection, Set<Statement>>();
    private String simpleUpdateSql;
    private String attributeUpdateSql;
    private String metadataUpdateSql;
    private String cleanupSql;
    private final byte[] emptyAttributes;

    protected RDBMSStoreBase() {
        try {
            SimpleCachableMarshalledValue empty = new SimpleCachableMarshalledValue(new HashMap());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(empty);
            oos.close();
            this.emptyAttributes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize simple HashMap");
        }
    }

    public abstract String getStoreName();

    public abstract String getInfo();

    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("Must configure a name for PersistentStore");
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public void setSessionTable(String sessionTable) {
        this.sessionTable = sessionTable;
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionAppCol(String sessionAppCol) {
        this.sessionAppCol = sessionAppCol;
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionIdCol(String sessionIdCol) {
        this.sessionIdCol = sessionIdCol;
    }

    public String getSessionFullIdCol() {
        return this.sessionFullIdCol;
    }

    public void setSessionFullIdCol(String sessionFullIdCol) {
        this.sessionFullIdCol = sessionFullIdCol;
    }

    public String getSessionCreationTimeCol() {
        return this.sessionCreationTimeCol;
    }

    public void setSessionCreationTimeCol(String sessionCreationTimeCol) {
        this.sessionCreationTimeCol = sessionCreationTimeCol;
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
    }

    public String getSessionNewCol() {
        return this.sessionNewCol;
    }

    public void setSessionNewCol(String sessionNewCol) {
        this.sessionNewCol = sessionNewCol;
    }

    public String getSessionVersionCol() {
        return this.sessionVersionCol;
    }

    public void setSessionVersionCol(String sessionVersionCol) {
        this.sessionVersionCol = sessionVersionCol;
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        this.sessionLastAccessedCol = sessionLastAccessedCol;
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionValidCol(String sessionValidCol) {
        this.sessionValidCol = sessionValidCol;
    }

    public String getSessionMetadataCol() {
        return this.sessionMetadataCol;
    }

    public void setSessionMetadataCol(String sessionMetadataCol) {
        this.sessionMetadataCol = sessionMetadataCol;
    }

    public String getSessionAttributeCol() {
        return this.sessionAttributeCol;
    }

    public void setSessionAttributeCol(String sessionAttributeCol) {
        this.sessionAttributeCol = sessionAttributeCol;
    }

    public int getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(int cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval = maxUnreplicatedInterval;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            try {
                PreparedStatement preparedClearSql = this.prepareStatement(_conn, this.getClearSql());
                preparedClearSql.setString(1, this.getName());
                preparedClearSql.execute();
                _conn.commit();
                success = true;
                exception = null;
                break;
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught SQLException executing store clear", e);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    if (success) continue;
                    this.cleanup(_conn, null, true);
                }
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int size = 0;
        ResultSet rst = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            try {
                PreparedStatement preparedSizeSql = this.prepareStatement(_conn, this.getSizeSql());
                preparedSizeSql.setString(1, this.getName());
                rst = preparedSizeSql.executeQuery();
                if (rst.next()) {
                    size = rst.getInt(1);
                }
                _conn.commit();
                success = true;
                exception = null;
                break;
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught SQLException getting store size", e);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    if (!success) {
                        this.cleanup(_conn, rst, true);
                        continue;
                    }
                    if (rst == null) continue;
                    rst.close();
                }
                catch (SQLException e) {}
                continue;
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSessionIds() {
        ResultSet rst = null;
        HashSet<String> keys = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Connection _conn = this.safeGetConnection();
            boolean success = true;
            try {
                PreparedStatement preparedKeysSql = this.prepareStatement(_conn, this.getKeysSql());
                preparedKeysSql.setString(1, this.getName());
                rst = preparedKeysSql.executeQuery();
                keys = new HashSet<String>();
                if (rst != null) {
                    while (rst.next()) {
                        keys.add(rst.getString(1));
                    }
                }
                _conn.commit();
                success = true;
                exception = null;
                break;
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught SQLException getting session ids", e);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    if (!success) {
                        this.cleanup(_conn, rst, true);
                        continue;
                    }
                    if (rst == null) continue;
                    rst.close();
                }
                catch (SQLException e) {}
                continue;
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncomingDistributableSessionData getSessionData(String realId, boolean includeAttributes) {
        ResultSet rst = null;
        IncomingDistributableSessionDataImpl incomingSession = null;
        ObjectInputStream attributes_ois = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            try {
                String sql = includeAttributes ? this.getFullLoadSql() : this.getPartialLoadSql();
                PreparedStatement preparedLoadSql = this.prepareStatement(_conn, sql);
                preparedLoadSql.setString(1, realId);
                preparedLoadSql.setString(2, this.getName());
                rst = preparedLoadSql.executeQuery();
                if (rst.next()) {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace((Object)("Loading session " + RDBMSStoreBase.maskId(realId)));
                    }
                    DistributableSessionMetadata metadata = new DistributableSessionMetadata();
                    metadata.setId(rst.getString(1));
                    metadata.setCreationTime(rst.getLong(2));
                    String isNew = rst.getString(3);
                    metadata.setNew("1".equals(isNew));
                    metadata.setMaxInactiveInterval(rst.getInt(4));
                    String valid = rst.getString(7);
                    metadata.setValid("1".equals(valid));
                    Integer version = rst.getInt(5);
                    Long timestamp = rst.getLong(6);
                    Map attributes = null;
                    if (includeAttributes) {
                        BufferedInputStream attributes_bis = new BufferedInputStream(rst.getBinaryStream(8));
                        attributes_ois = new ObjectInputStream(attributes_bis);
                        SimpleCachableMarshalledValue mv = (SimpleCachableMarshalledValue)attributes_ois.readObject();
                        attributes = (Map)RDBMSStoreBase.uncheckedCast(mv.get());
                    }
                    incomingSession = new IncomingDistributableSessionDataImpl(version, timestamp, metadata, attributes);
                } else if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace((Object)(this.getStoreName() + ": No persisted data object found"));
                }
                _conn.commit();
                success = true;
                exception = null;
                break;
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught SQLException loading session " + RDBMSStoreBase.maskId(realId), e);
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught IOException loading session " + RDBMSStoreBase.maskId(realId), e);
            }
            catch (ClassNotFoundException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught ClassNotFoundException loading session " + RDBMSStoreBase.maskId(realId), e);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    if (!success) {
                        this.cleanup(_conn, rst, true);
                    } else if (rst != null) {
                        rst.close();
                    }
                    if (attributes_ois == null) continue;
                    try {
                        attributes_ois.close();
                    }
                    catch (IOException e) {}
                }
                catch (SQLException e) {}
                continue;
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return incomingSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String realId) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Loading session " + RDBMSStoreBase.maskId(realId)));
        }
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            try {
                this.executeRemove(realId, _conn);
                _conn.commit();
                success = true;
                exception = null;
                break;
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught SQLException removing session " + RDBMSStoreBase.maskId(realId), e);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    if (success) continue;
                    this.cleanup(_conn, null, true);
                }
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSessionData(OutgoingSessionGranularitySessionData sessionData) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Storing session " + RDBMSStoreBase.maskId(sessionData)));
        }
        RuntimeException exception = null;
        ObjectOutputStream oos = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            boolean success = false;
            Connection _conn = this.safeGetConnection();
            if (_conn == null) {
                return;
            }
            try {
                byte[] obs = this.writeSessionAttributes(sessionData);
                DistributableSessionMetadata metadata = sessionData.getMetadata();
                if (metadata != null && metadata.isNew()) {
                    try {
                        this.executeInsert(sessionData, obs, _conn);
                    }
                    catch (SQLException e) {
                        if (this.getLogger().isTraceEnabled()) {
                            this.getLogger().trace((Object)("Caught SQLException inserting session " + RDBMSStoreBase.maskId(sessionData)), (Throwable)e);
                        }
                        this.cleanup(_conn, null, true);
                        _conn = null;
                        _conn = this.safeGetConnection();
                        if (obs != null && this.executeGetSessionVersion(_conn, sessionData.getRealId()) != null) {
                            this.executeReInsert(sessionData, obs, _conn);
                        }
                        throw e;
                    }
                } else {
                    int count = this.executeUpdate(sessionData, obs, _conn);
                    if (count < 1) {
                        if (metadata != null && obs != null) {
                            this.executeInsert(sessionData, obs, _conn);
                        } else {
                            throw new IllegalStateException("Cannot insert session " + RDBMSStoreBase.maskId(sessionData) + " as session metadata is not available");
                        }
                    }
                }
                _conn.commit();
                success = true;
                exception = null;
                break;
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught SQLException storing session " + RDBMSStoreBase.maskId(sessionData), e);
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught IOException storing session " + RDBMSStoreBase.maskId(sessionData), e);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    if (!success) {
                        this.cleanup(_conn, null, true);
                    }
                    if (oos == null) continue;
                    try {
                        oos.close();
                    }
                    catch (IOException ignored) {}
                }
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static String maskId(OutgoingSessionGranularitySessionData sessionData) {
        String realId = sessionData == null ? null : sessionData.getRealId();
        return RDBMSStoreBase.maskId(realId);
    }

    private static String maskId(String realId) {
        if (realId == null) {
            return null;
        }
        int length = realId.length();
        if (length <= 8) {
            return realId;
        }
        StringBuilder sb = new StringBuilder(realId.substring(0, 2));
        sb.append("****");
        sb.append(realId.substring(length - 6, length));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Long getSessionTimestamp(String realId) {
        ResultSet rst = null;
        Long result = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            boolean success = false;
            Connection _conn = this.safeGetConnection();
            PreparedStatement preparedTimestampSql = this.prepareStatement(_conn, this.getTimestampSql());
            preparedTimestampSql.setString(1, realId);
            preparedTimestampSql.setString(2, this.getName());
            rst = preparedTimestampSql.executeQuery();
            if (rst.next()) {
                result = rst.getLong(1);
            }
            _conn.commit();
            success = true;
            exception = null;
            try {
                if (!success) {
                    this.cleanup(_conn, rst, true);
                    break;
                }
                if (rst == null) break;
                try {
                    rst.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                break;
            }
            finally {
                this.releaseConnection(_conn);
            }
            catch (SQLException e) {
                block35: {
                    if (exception != null) break block35;
                    exception = new RuntimeException("Caught SQLException getting timestamp for session " + RDBMSStoreBase.maskId(realId), e);
                }
                try {
                    if (!success) {
                        this.cleanup(_conn, rst, true);
                        continue;
                    }
                    if (rst == null) continue;
                    try {
                        rst.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    continue;
                }
                finally {
                    this.releaseConnection(_conn);
                    continue;
                }
            }
            catch (RuntimeException e2) {
                block36: {
                    if (exception != null) break block36;
                    exception = e2;
                    {
                        catch (Throwable throwable) {
                            try {
                                if (!success) {
                                    this.cleanup(_conn, rst, true);
                                } else if (rst != null) {
                                    try {
                                        rst.close();
                                    }
                                    catch (SQLException e3) {
                                        // empty catch block
                                    }
                                }
                            }
                            finally {
                                this.releaseConnection(_conn);
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    if (!success) {
                        this.cleanup(_conn, rst, true);
                        continue;
                    }
                    if (rst == null) continue;
                    try {
                        rst.close();
                    }
                    catch (SQLException e4) {
                        // empty catch block
                    }
                }
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getSessionVersion(String realId) {
        Integer result = null;
        RuntimeException exception = null;
        int numberOfTries = 2;
        while (numberOfTries-- > 0) {
            boolean success = false;
            Connection _conn = this.safeGetConnection();
            try {
                result = this.executeGetSessionVersion(_conn, realId);
                _conn.commit();
                success = true;
                exception = null;
                break;
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = new RuntimeException("Caught SQLException getting version for session " + RDBMSStoreBase.maskId(realId), e);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
            finally {
                try {
                    if (success) continue;
                    this.cleanup(_conn, null, true);
                }
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processExpires() {
        long interval;
        long now = System.currentTimeMillis();
        long earliest = now - (interval = (long)(this.cleanupInterval * 1000));
        if (earliest > this.lastCleanup) {
            long maxUnrep = this.maxUnreplicatedInterval < 0 ? 60000L : (long)(this.maxUnreplicatedInterval * 1000);
            Connection _conn = this.safeGetConnection();
            boolean success = false;
            try {
                PreparedStatement preparedCleanupSql = this.prepareStatement(_conn, this.getCleanupSql());
                preparedCleanupSql.setString(1, this.getName());
                preparedCleanupSql.setLong(2, earliest);
                preparedCleanupSql.setLong(3, now - maxUnrep);
                preparedCleanupSql.execute();
                _conn.commit();
                this.lastCleanup = now;
                success = true;
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Caught exception cleaning out expired sessions", (Throwable)e);
            }
            finally {
                try {
                    if (!success) {
                        this.cleanup(_conn, null, true);
                    }
                }
                finally {
                    this.releaseConnection(_conn);
                }
            }
        }
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException(this.getStoreName() + " is already started");
        }
        this.getName();
        this.createSql();
        this.startStore();
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            throw new IllegalStateException(this.getStoreName() + " is not started");
        }
        this.started = false;
    }

    protected abstract void startStore();

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void releaseConnection(Connection var1);

    protected void cleanup(Connection conn, ResultSet resultSet, boolean rollback) {
        if (conn != null) {
            Set<Statement> stmts;
            block13: {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().warn((Object)("Caught SQLException closing a result set -- " + e.getLocalizedMessage()));
                    }
                }
                if (rollback) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        if (!this.getLogger().isTraceEnabled()) break block13;
                        this.getLogger().trace((Object)("Caught SQLException rolling back connection -- " + e.getLocalizedMessage()), (Throwable)e);
                    }
                }
            }
            if ((stmts = this.statementsByConnection.remove(conn)) != null) {
                for (Statement stmt : stmts) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().debug((Object)("Caught SQLException closing statement -- " + e.getLocalizedMessage()));
                    }
                }
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.getLogger().error((Object)("Caught SQLException closing connection -- " + e.getLocalizedMessage()));
            }
        }
    }

    protected Logger getLogger() {
        return this.logger == null ? LOG : this.logger;
    }

    private void createSql() {
        this.clearSql = "DELETE FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?";
        this.keysSql = "SELECT " + this.getSessionIdCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?";
        this.sizeSql = "SELECT COUNT(" + this.getSessionIdCol() + ") " + "        FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?";
        this.fullLoadSql = "SELECT " + this.getSessionFullIdCol() + ", " + this.getSessionCreationTimeCol() + ", " + this.getSessionNewCol() + ", " + this.getSessionMaxInactiveCol() + ", " + this.getSessionVersionCol() + ", " + this.getSessionLastAccessedCol() + ", " + this.getSessionValidCol() + ", " + this.getSessionAttributeCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.partialLoadSql = "SELECT " + this.getSessionFullIdCol() + ", " + this.getSessionCreationTimeCol() + ", " + this.getSessionNewCol() + ", " + this.getSessionMaxInactiveCol() + ", " + this.getSessionVersionCol() + ", " + this.getSessionLastAccessedCol() + ", " + this.getSessionValidCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.removeSql = "DELETE FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.insertSql = "INSERT INTO " + this.getSessionTable() + " (" + this.getSessionAppCol() + ", " + this.getSessionIdCol() + ", " + this.getSessionFullIdCol() + ", " + this.getSessionCreationTimeCol() + ", " + this.getSessionNewCol() + ", " + this.getSessionMaxInactiveCol() + ", " + this.getSessionVersionCol() + ", " + this.getSessionLastAccessedCol() + ", " + this.getSessionValidCol() + ", " + this.getSessionAttributeCol() + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.simpleUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.attributeUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?, " + this.getSessionAttributeCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.metadataUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?, " + this.getSessionFullIdCol() + " = ?, " + this.getSessionNewCol() + " = ?, " + this.getSessionMaxInactiveCol() + " = ?, " + this.getSessionValidCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.fullUpdateSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?, " + this.getSessionFullIdCol() + " = ?, " + this.getSessionNewCol() + " = ?, " + this.getSessionMaxInactiveCol() + " = ?, " + this.getSessionValidCol() + " = ?, " + this.getSessionAttributeCol() + " = ?" + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.reinsertSql = "UPDATE " + this.getSessionTable() + " SET " + this.getSessionVersionCol() + " = ?, " + this.getSessionLastAccessedCol() + " = ?, " + this.getSessionFullIdCol() + " = ?, " + this.getSessionNewCol() + " = ?, " + this.getSessionMaxInactiveCol() + " = ?, " + this.getSessionValidCol() + " = ?, " + this.getSessionAttributeCol() + " = ?, " + this.getSessionCreationTimeCol() + " = ? WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.timestampSql = "SELECT " + this.getSessionLastAccessedCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.versionSql = "SELECT " + this.getSessionVersionCol() + " FROM " + this.getSessionTable() + " WHERE " + this.getSessionIdCol() + " = ? AND " + this.getSessionAppCol() + " = ?";
        this.cleanupSql = "DELETE FROM " + this.getSessionTable() + " WHERE " + this.getSessionAppCol() + " = ?" + " AND " + this.getSessionLastAccessedCol() + " < ? AND " + this.getSessionLastAccessedCol() + " < (? - (" + this.getSessionMaxInactiveCol() + " * 1000))";
    }

    private void executeRemove(String id, Connection _conn) throws SQLException {
        PreparedStatement preparedRemoveSql = this.prepareStatement(_conn, this.getRemoveSql());
        preparedRemoveSql.setString(1, id);
        preparedRemoveSql.setString(2, this.getName());
        preparedRemoveSql.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInsert(OutgoingSessionGranularitySessionData session, byte[] obs, Connection conn) throws SQLException, IOException {
        DistributableSessionMetadata metadata;
        if (obs == null) {
            obs = this.emptyAttributes;
        }
        if ((metadata = session.getMetadata()) == null) {
            throw new IllegalStateException("Cannot insert session " + RDBMSStoreBase.maskId(session) + " as session metadata is missing");
        }
        int size = obs.length;
        ByteArrayInputStream bis = new ByteArrayInputStream(obs);
        BufferedInputStream in = new BufferedInputStream(bis, size);
        try {
            PreparedStatement preparedInsertSql = this.prepareStatement(conn, this.getInsertSql());
            preparedInsertSql.setString(1, this.getName());
            preparedInsertSql.setString(2, session.getRealId());
            preparedInsertSql.setString(3, metadata.getId());
            preparedInsertSql.setLong(4, metadata.getCreationTime());
            preparedInsertSql.setString(5, metadata.isNew() ? "1" : "0");
            preparedInsertSql.setInt(6, metadata.getMaxInactiveInterval());
            preparedInsertSql.setInt(7, session.getVersion());
            preparedInsertSql.setLong(8, session.getTimestamp());
            preparedInsertSql.setString(9, metadata.isValid() ? "1" : "0");
            preparedInsertSql.setBinaryStream(10, (InputStream)in, size);
            preparedInsertSql.execute();
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeReInsert(OutgoingSessionGranularitySessionData session, byte[] obs, Connection conn) throws SQLException, IOException {
        DistributableSessionMetadata metadata = session.getMetadata();
        int size = obs.length;
        InputStream in = null;
        if (obs != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(obs);
            in = new BufferedInputStream(bis, size);
        }
        try {
            int count;
            PreparedStatement preparedUpdateSql = this.prepareStatement(conn, this.getReInsertSql());
            preparedUpdateSql.setInt(1, session.getVersion());
            preparedUpdateSql.setLong(2, session.getTimestamp());
            preparedUpdateSql.setString(3, metadata.getId());
            preparedUpdateSql.setString(4, metadata.isNew() ? "1" : "0");
            preparedUpdateSql.setInt(5, metadata.getMaxInactiveInterval());
            preparedUpdateSql.setString(6, metadata.isValid() ? "1" : "0");
            preparedUpdateSql.setBinaryStream(7, in, size);
            preparedUpdateSql.setLong(8, metadata.getCreationTime());
            preparedUpdateSql.setString(9, session.getRealId());
            preparedUpdateSql.setString(10, this.getName());
            int n = count = preparedUpdateSql.executeUpdate();
            return n;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(OutgoingSessionGranularitySessionData session, byte[] obs, Connection conn) throws SQLException, IOException {
        DistributableSessionMetadata metadata = session.getMetadata();
        int size = obs == null ? -1 : obs.length;
        InputStream in = null;
        if (obs != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(obs);
            in = new BufferedInputStream(bis, size);
        }
        try {
            int count;
            PreparedStatement preparedUpdateSql = null;
            int idParam = -1;
            if (metadata != null) {
                if (obs != null) {
                    preparedUpdateSql = this.prepareStatement(conn, this.getFullUpdateSql());
                    preparedUpdateSql.setBinaryStream(7, in, size);
                    idParam = 8;
                } else {
                    preparedUpdateSql = this.prepareStatement(conn, this.getMetadataUpdateSql());
                    idParam = 7;
                }
                preparedUpdateSql.setString(3, metadata.getId());
                preparedUpdateSql.setString(4, metadata.isNew() ? "1" : "0");
                preparedUpdateSql.setInt(5, metadata.getMaxInactiveInterval());
                preparedUpdateSql.setString(6, metadata.isValid() ? "1" : "0");
            } else if (obs != null) {
                preparedUpdateSql = this.prepareStatement(conn, this.getAttributeUpdateSql());
                preparedUpdateSql.setBinaryStream(3, in, size);
                idParam = 4;
            } else {
                preparedUpdateSql = this.prepareStatement(conn, this.getSimpleUpdateSql());
                idParam = 3;
            }
            preparedUpdateSql.setInt(1, session.getVersion());
            preparedUpdateSql.setLong(2, session.getTimestamp());
            preparedUpdateSql.setString(idParam, session.getRealId());
            preparedUpdateSql.setString(idParam + 1, this.getName());
            int n = count = preparedUpdateSql.executeUpdate();
            return n;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer executeGetSessionVersion(Connection _conn, String realId) throws SQLException {
        PreparedStatement preparedTimestampSql = this.prepareStatement(_conn, this.getVersionSql());
        preparedTimestampSql.setString(1, realId);
        preparedTimestampSql.setString(2, this.getName());
        ResultSet rst = null;
        try {
            Integer result = null;
            rst = preparedTimestampSql.executeQuery();
            if (rst.next()) {
                result = rst.getInt(1);
            }
            Integer n = result;
            return n;
        }
        finally {
            if (rst != null) {
                rst.close();
            }
        }
    }

    private String getCleanupSql() {
        return this.cleanupSql;
    }

    private String getClearSql() {
        return this.clearSql;
    }

    private String getInsertSql() {
        return this.insertSql;
    }

    private String getFullUpdateSql() {
        return this.fullUpdateSql;
    }

    private String getReInsertSql() {
        return this.reinsertSql;
    }

    private String getSimpleUpdateSql() {
        return this.simpleUpdateSql;
    }

    private String getMetadataUpdateSql() {
        return this.metadataUpdateSql;
    }

    private String getAttributeUpdateSql() {
        return this.attributeUpdateSql;
    }

    private String getKeysSql() {
        return this.keysSql;
    }

    private String getFullLoadSql() {
        return this.fullLoadSql;
    }

    private String getPartialLoadSql() {
        return this.partialLoadSql;
    }

    private String getRemoveSql() {
        return this.removeSql;
    }

    private String getSizeSql() {
        return this.sizeSql;
    }

    private String getVersionSql() {
        return this.versionSql;
    }

    private String getTimestampSql() {
        return this.timestampSql;
    }

    private Connection safeGetConnection() {
        try {
            return this.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Caught SQLException getting a connection", e);
        }
    }

    private PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        Set<Statement> stmts = this.statementsByConnection.get(conn);
        if (stmts == null) {
            stmts = new HashSet<Statement>();
            this.statementsByConnection.put(conn, stmts);
        }
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmts.add(stmt);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeSessionAttributes(OutgoingSessionGranularitySessionData session) throws IOException {
        Map attrs = session.getSessionAttributes();
        if (attrs == null) {
            return null;
        }
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            oos.writeObject(new SimpleCachableMarshalledValue((Serializable)((Object)attrs)));
            oos.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    private static <T> T uncheckedCast(Object obj) {
        return (T)obj;
    }
}

