/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.statistics;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationStatistics
implements Serializable {
    private static final long serialVersionUID = 9153807780893455734L;
    private Map<String, TimeStatistic> ctxStats;
    public long lastResetTime = System.currentTimeMillis();

    public ReplicationStatistics() {
        this.ctxStats = new ConcurrentHashMap<String, TimeStatistic>(256, 0.75f, 32);
    }

    public void updatePassivationStats(String ctx, long elapsed) {
        TimeStatistic stat = this.getTimeStatistic(ctx);
        stat.totalPassivationTime += elapsed;
        if (stat.minPassivationTime > elapsed) {
            stat.minPassivationTime = elapsed;
        }
        if (stat.maxPassivationTime < elapsed) {
            stat.maxPassivationTime = elapsed;
        }
    }

    public void updateReplicationStats(String ctx, long elapsed) {
        TimeStatistic stat = this.getTimeStatistic(ctx);
        ++stat.replicationCount;
        stat.totalReplicationlTime += elapsed;
        if (stat.minReplicationTime > elapsed) {
            stat.minReplicationTime = elapsed;
        }
        if (stat.maxReplicationTime < elapsed) {
            stat.maxReplicationTime = elapsed;
        }
    }

    public void updateLoadStats(String ctx, long elapsed) {
        TimeStatistic stat = this.getTimeStatistic(ctx);
        ++stat.loadCount;
        stat.totalLoadlTime += elapsed;
        if (stat.minLoadTime > elapsed) {
            stat.minLoadTime = elapsed;
        }
        if (stat.maxLoadTime < elapsed) {
            stat.maxLoadTime = elapsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Map<String, TimeStatistic> map = this.ctxStats;
        synchronized (map) {
            for (TimeStatistic stat : this.ctxStats.values()) {
                stat.reset();
            }
        }
        this.lastResetTime = System.currentTimeMillis();
    }

    public void removeStats(String id) {
        this.ctxStats.remove(id);
    }

    public Map<String, TimeStatistic> getStats() {
        return this.ctxStats;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        for (Map.Entry<String, TimeStatistic> entry : this.ctxStats.entrySet()) {
            TimeStatistic stat = entry.getValue();
            if (stat == null) continue;
            tmp.append("[sessionID: ");
            tmp.append(entry.getKey());
            tmp.append(", replicationCount=");
            tmp.append(stat.replicationCount);
            tmp.append(", minPassivationTime=");
            tmp.append(stat.minPassivationTime);
            tmp.append(", maxPassivationTime=");
            tmp.append(stat.maxPassivationTime);
            tmp.append(", totalPassivationTime=");
            tmp.append(stat.totalPassivationTime);
            tmp.append(", minReplicationTime=");
            tmp.append(stat.minReplicationTime);
            tmp.append(", maxReplicationTime=");
            tmp.append(stat.maxReplicationTime);
            tmp.append(", totalReplicationlTime=");
            tmp.append(stat.totalReplicationlTime);
            tmp.append(", loadCount=");
            tmp.append(stat.loadCount);
            tmp.append(", minLoadTime=");
            tmp.append(stat.minLoadTime);
            tmp.append(", maxLoadTime=");
            tmp.append(stat.maxLoadTime);
            tmp.append(", totaLoadlTime=");
            tmp.append(stat.totalLoadlTime);
            tmp.append("];");
        }
        tmp.append(")");
        return tmp.toString();
    }

    private TimeStatistic getTimeStatistic(String ctx) {
        TimeStatistic stat = this.ctxStats.get(ctx);
        if (stat == null) {
            stat = new TimeStatistic();
            this.ctxStats.put(ctx, stat);
        }
        return stat;
    }

    public static class TimeStatistic {
        public long replicationCount;
        public long minPassivationTime = Long.MAX_VALUE;
        public long maxPassivationTime;
        public long totalPassivationTime;
        public long minReplicationTime = Long.MAX_VALUE;
        public long maxReplicationTime;
        public long totalReplicationlTime;
        public long loadCount;
        public long minLoadTime = Long.MAX_VALUE;
        public long maxLoadTime;
        public long totalLoadlTime;

        public void reset() {
            this.replicationCount = 0L;
            this.minPassivationTime = Long.MAX_VALUE;
            this.maxPassivationTime = 0L;
            this.totalPassivationTime = 0L;
            this.minReplicationTime = Long.MAX_VALUE;
            this.maxReplicationTime = 0L;
            this.totalReplicationlTime = 0L;
            this.loadCount = 0L;
            this.minLoadTime = Long.MAX_VALUE;
            this.maxLoadTime = 0L;
            this.totalLoadlTime = 0L;
        }
    }
}

