/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.actions;

import java.io.Serializable;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.persistence.repository.PersistenceRepository;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.management.ManagementAction;
import org.jboss.profileservice.spi.action.management.ManagementActionContext;

public class UpdateComponentAction
extends AbstractTwoPhaseModificationAction<ManagementActionContext>
implements ManagementAction<ManagementActionContext> {
    private ManagedComponent updatedComponent;
    private ManagedComponent serverComponent;
    private AbstractManagementProxyFactory proxyFactory;
    private PersistenceRepository persistenceRepository;

    public UpdateComponentAction(ManagedComponent updatedComponent, ManagedComponent serverComponent, AbstractManagementProxyFactory proxyFactory, PersistenceRepository persistenceRepository, ManagementActionContext modificationContext) {
        super((ProfileModificationContext)modificationContext);
        this.updatedComponent = updatedComponent;
        this.serverComponent = serverComponent;
        this.persistenceRepository = persistenceRepository;
        this.proxyFactory = proxyFactory;
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            for (ManagedProperty prop : this.updatedComponent.getProperties().values()) {
                String mappedName;
                boolean skip = prop.getValue() == null || prop.isReadOnly() || !prop.hasViewUse(ViewUse.CONFIGURATION) || prop.isRemoved();
                if (skip) continue;
                ManagedProperty ctxProp = (ManagedProperty)this.serverComponent.getProperties().get(prop.getName());
                if (ctxProp == null && (mappedName = prop.getMappedName()) != null) {
                    ctxProp = (ManagedProperty)this.serverComponent.getProperties().get(mappedName);
                }
                if (ctxProp == null) {
                    throw new IllegalArgumentException("trying to update non existing property." + prop.getName());
                }
                MetaValue value = prop.getValue();
                if (!(value instanceof MetaValue)) {
                    throw new IllegalArgumentException("invalid value for property " + prop.getName());
                }
                MetaValue metaValue = value;
                ctxProp.setField("metaType", (Serializable)metaValue.getMetaType());
                ctxProp.setValue(metaValue);
                Object componentName = this.getComponentName(ctxProp);
                ActivationPolicy policy = ctxProp.getActivationPolicy();
                if (componentName == null || !policy.equals((Object)ActivationPolicy.IMMEDIATE)) continue;
                this.getProxyFactory().getDispatcher().set(componentName, ctxProp, metaValue);
            }
            if (this.persistenceRepository.isSupportPersistence(this.serverComponent)) {
                ManagedDeployment deployment = this.serverComponent.getDeployment();
                this.persistenceRepository.updateDeployment(deployment.getName(), this.serverComponent);
            }
        }
        catch (Throwable t) {
            response.setFailure(t);
            return false;
        }
        return true;
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromPrepared() {
    }

    protected void doRollbackFromRollbackOnly() {
    }

    protected AbstractManagementProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected Object getComponentName(ManagedProperty property) {
        ManagedObject targetObject = property.getTargetManagedObject();
        if (targetObject != null) {
            return targetObject.getComponentName();
        }
        targetObject = property.getManagedObject();
        return targetObject != null ? targetObject.getComponentName() : null;
    }
}

