/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.cdi.JaxrsAnnotatedType;
import org.jboss.resteasy.cdi.JaxrsInjectionTarget;
import org.jboss.resteasy.cdi.Utils;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.util.GetRestful;

public class ResteasyCdiExtension
implements Extension {
    private BeanManager beanManager;
    private static final String JAVAX_EJB_STATELESS = "javax.ejb.Stateless";
    private static final String JAVAX_EJB_SINGLETON = "javax.ejb.Singleton";
    private final Logger log = Logger.getLogger(ResteasyCdiExtension.class);
    public static final Annotation requestScopedLiteral = new AnnotationLiteral<RequestScoped>(){
        private static final long serialVersionUID = 3381824686081435817L;
    };
    public static final Annotation applicationScopedLiteral = new AnnotationLiteral<ApplicationScoped>(){
        private static final long serialVersionUID = -8211157243671012820L;
    };
    private Map<Class<?>, Type> sessionBeanInterface = new HashMap();

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public <T> void observeResources(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (!type.getJavaClass().isInterface()) {
            for (Annotation annotation : type.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.getName().equals(JAVAX_EJB_STATELESS) && !annotationType.getName().equals(JAVAX_EJB_SINGLETON)) continue;
                this.log.debug("Bean {0} is a SLSB or Singleton. Leaving scope unmodified.", new Object[]{type.getJavaClass()});
                return;
            }
            if (type.isAnnotationPresent(Provider.class)) {
                this.log.debug("Discovered CDI bean which is a JAX-RS provider {0}.", new Object[]{type.getJavaClass().getCanonicalName()});
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            } else if (GetRestful.isRootResource((Class)type.getJavaClass())) {
                this.log.debug("Discovered CDI bean which is a JAX-RS resource {0}.", new Object[]{type.getJavaClass().getCanonicalName()});
                event.setAnnotatedType(this.wrapAnnotatedType(type, requestScopedLiteral));
            } else if (Application.class.isAssignableFrom(type.getJavaClass())) {
                this.log.debug("Discovered CDI bean which is javax.ws.rs.core.Application subclass {0}.", new Object[]{type.getJavaClass().getCanonicalName()});
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            }
        }
    }

    protected <T> AnnotatedType<T> wrapAnnotatedType(AnnotatedType<T> type, Annotation scope) {
        if (Utils.isScopeDefined(type.getJavaClass(), this.beanManager)) {
            this.log.debug("Bean {0} has a scope defined.", new Object[]{type.getJavaClass()});
            return type;
        }
        this.log.debug("Bean {0} does not have the scope defined. Binding to {1}.", new Object[]{type.getJavaClass(), scope});
        return new JaxrsAnnotatedType<T>(type, scope);
    }

    public <T> void observeInjectionTarget(@Observes ProcessInjectionTarget<T> event) {
        if (event.getAnnotatedType() == null) {
            this.log.warn("ProcessInjectionTarget.getAnnotatedType() returned null. As a result, JAX-RS property injection will not work.");
            return;
        }
        if (Utils.isJaxrsComponent(event.getAnnotatedType().getJavaClass())) {
            event.setInjectionTarget(this.wrapInjectionTarget(event));
        }
    }

    protected <T> InjectionTarget<T> wrapInjectionTarget(ProcessInjectionTarget<T> event) {
        return new JaxrsInjectionTarget(event.getInjectionTarget(), event.getAnnotatedType().getJavaClass());
    }

    public <T> void observeSessionBeans(@Observes ProcessSessionBean<T> event) {
        Bean sessionBean = event.getBean();
        if (Utils.isJaxrsComponent(sessionBean.getBeanClass())) {
            this.addSessionBeanInterface(sessionBean);
        }
    }

    private void addSessionBeanInterface(Bean<?> bean) {
        for (Type type : bean.getTypes()) {
            Class clazz;
            if (!(type instanceof Class) || !((Class)type).isInterface() || !Utils.isJaxrsAnnotatedClass(clazz = (Class)type)) continue;
            this.sessionBeanInterface.put(bean.getBeanClass(), type);
            this.log.debug("{0} will be used for {1} lookup", new Object[]{type, bean.getBeanClass()});
            return;
        }
        this.log.debug("No lookup interface found for {0}", new Object[]{bean.getBeanClass()});
    }

    public Map<Class<?>, Type> getSessionBeanInterface() {
        return this.sessionBeanInterface;
    }
}

