/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.plugins.structure.ClassPathEntryImpl;
import org.jboss.deployers.spi.attachments.helpers.PredeterminedManagedObjectAttachmentsImpl;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataEntry;
import org.jboss.deployers.spi.structure.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextInfoImpl
extends PredeterminedManagedObjectAttachmentsImpl
implements ContextInfo,
Externalizable {
    private static final long serialVersionUID = -4384869824260284607L;
    private String path;
    private List<MetaDataEntry> metaDataPath;
    private List<ClassPathEntry> classPath = ClassPathEntryImpl.DEFAULT;
    private int relativeOrder = 0;
    private String comparatorClassName;
    private ModificationType modificationType;

    public ContextInfoImpl() {
        this.setPath("");
    }

    public ContextInfoImpl(String path) {
        this.setPath(path);
    }

    public ContextInfoImpl(String path, List<ClassPathEntry> classPath) {
        this.setPath(path);
        this.setClassPath(classPath);
    }

    public ContextInfoImpl(String path, MetaDataEntry metaDataPath, List<ClassPathEntry> classPath) {
        this.setPath(path);
        if (metaDataPath == null) {
            throw new IllegalArgumentException("Null metadata path.");
        }
        this.setMetaDataPath(Collections.singletonList(metaDataPath));
        this.setClassPath(classPath);
    }

    public ContextInfoImpl(String path, List<MetaDataEntry> metaDataPath, List<ClassPathEntry> classPath) {
        this.setPath(path);
        this.setMetaDataPath(metaDataPath);
        this.setClassPath(classPath);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.path = path;
    }

    public List<MetaDataEntry> getMetaDataPath() {
        if (this.metaDataPath == null) {
            return Collections.emptyList();
        }
        return this.metaDataPath;
    }

    public void setMetaDataPath(List<MetaDataEntry> metaDataPath) {
        this.metaDataPath = metaDataPath;
    }

    public void addMetaDataPath(MetaDataEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (this.metaDataPath == null) {
            this.metaDataPath = Collections.singletonList(entry);
        } else if (this.metaDataPath.size() == 1) {
            ArrayList<MetaDataEntry> paths = new ArrayList<MetaDataEntry>();
            paths.addAll(this.metaDataPath);
            paths.add(entry);
            this.metaDataPath = paths;
        } else {
            this.metaDataPath.add(entry);
        }
    }

    public List<ClassPathEntry> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(List<ClassPathEntry> classPath) {
        this.classPath = classPath;
    }

    public void addClassPathEntry(ClassPathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        if (this.classPath == null || this.classPath == ClassPathEntryImpl.DEFAULT) {
            List<ClassPathEntry> old = this.classPath;
            this.classPath = new ArrayList<ClassPathEntry>();
            if (old != null) {
                this.classPath.addAll(old);
            }
        }
        this.classPath.add(entry);
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public void setComparatorClassName(String className) {
        this.comparatorClassName = className;
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int relativeOrder) {
        this.relativeOrder = relativeOrder;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public void setModificationType(ModificationType modificationType) {
        this.modificationType = modificationType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("{");
        this.toString(builder);
        builder.append("}");
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
        builder.append("path=").append(this.getPath());
        builder.append(" metaData=").append(this.getMetaDataPath());
        builder.append(" classPath=").append(this.getClassPath());
        if (this.relativeOrder != 0) {
            builder.append(" relativeOrder=").append(this.getRelativeOrder());
        }
        if (this.comparatorClassName != null) {
            builder.append(" comparator=").append(this.getComparatorClassName());
        }
        if (this.modificationType != null) {
            builder.append(" modification=").append(this.modificationType);
        }
    }

    public boolean equals(Object obj) {
        List otherMetaDataPath;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ContextInfo)) {
            return false;
        }
        ContextInfo other = (ContextInfo)obj;
        if (!this.getPath().equals(other.getPath())) {
            return false;
        }
        List<MetaDataEntry> thisMetaDataPath = this.getMetaDataPath();
        if (!((Object)thisMetaDataPath).equals(otherMetaDataPath = other.getMetaDataPath())) {
            return false;
        }
        List<ClassPathEntry> thisClassPath = this.getClassPath();
        List otherClassPath = other.getClassPath();
        if (thisClassPath == null) {
            return otherClassPath == null;
        }
        return ((Object)thisClassPath).equals(otherClassPath);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.setPath(in.readUTF());
        boolean isEmptyMetaDataPath = in.readBoolean();
        if (!isEmptyMetaDataPath) {
            this.setMetaDataPath((List)in.readObject());
        }
        this.setClassPath((List)in.readObject());
        this.setRelativeOrder(in.readInt());
        boolean isNullComparator = in.readBoolean();
        if (!isNullComparator) {
            this.setComparatorClassName(in.readUTF());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.getPath());
        List<MetaDataEntry> metaDataPath = this.getMetaDataPath();
        boolean isEmptyMetaDataPath = metaDataPath.isEmpty();
        out.writeBoolean(isEmptyMetaDataPath);
        if (!isEmptyMetaDataPath) {
            out.writeObject(metaDataPath);
        }
        out.writeObject(this.getClassPath());
        out.writeInt(this.getRelativeOrder());
        String comparator = this.getComparatorClassName();
        boolean isNullComparator = comparator == null;
        out.writeBoolean(isNullComparator);
        if (!isNullComparator) {
            out.writeUTF(comparator);
        }
    }
}

