/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.servlet.annotation.MultipartConfig;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.AnnotationMetaData;
import org.jboss.metadata.web.spec.AnnotationsMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartConfigProcessor
extends AbstractFinderUser
implements Processor<AnnotationsMetaData, Class<?>>,
Creator<Class<?>, MultipartConfigMetaData> {
    public MultipartConfigProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(AnnotationsMetaData metaData, Class<?> type) {
        MultipartConfig annotation = (MultipartConfig)this.finder.getAnnotation(type, MultipartConfig.class);
        if (annotation == null) {
            return;
        }
        MultipartConfigMetaData multipartConfig = this.create(type);
        AnnotationMetaData annotationMD = (AnnotationMetaData)metaData.get(type.getName());
        if (annotationMD == null) {
            annotationMD = new AnnotationMetaData();
            annotationMD.setClassName(type.getName());
            metaData.add((MappableMetaData)annotationMD);
        }
        annotationMD.setMultipartConfig(multipartConfig);
    }

    public MultipartConfigMetaData create(Class<?> element) {
        MultipartConfig multipartConfig = (MultipartConfig)this.finder.getAnnotation(element, MultipartConfig.class);
        if (multipartConfig == null) {
            return null;
        }
        MultipartConfigMetaData metaData = new MultipartConfigMetaData();
        if (!"".equals(multipartConfig.location())) {
            metaData.setLocation(multipartConfig.location());
        }
        if (multipartConfig.maxFileSize() != -1L) {
            metaData.setMaxFileSize(multipartConfig.maxFileSize());
        }
        if (multipartConfig.maxRequestSize() != -1L) {
            metaData.setMaxRequestSize(multipartConfig.maxRequestSize());
        }
        if (multipartConfig.fileSizeThreshold() != 0) {
            metaData.setFileSizeThreshold(multipartConfig.fileSizeThreshold());
        }
        return metaData;
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(MultipartConfig.class);
    }
}

