/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractContentModificationGenerator;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;

public class LocalContentModificationGenerator
extends AbstractContentModificationGenerator {
    private static final Logger log = Logger.getLogger(LocalContentModificationGenerator.class);

    protected void handleAddition(String rootName, RepositoryItemMetadata item, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        ContentModification.Type type = item.isDirectory() ? ContentModification.Type.MKDIR_TO_CLUSTER : ContentModification.Type.PUSH_TO_CLUSTER;
        mods.addModification(new ContentModification(type, rootName, item));
        if (log.isTraceEnabled()) {
            log.trace((Object)("created " + (Object)((Object)type) + " modification for " + item.getRelativePath()));
        }
    }

    protected void handleMissing(String rootName, RepositoryItemMetadata item, AbstractContentModificationGenerator.GeneratedModifications mods) {
        if (!item.isRemoved()) {
            this.handleRemoval(rootName, item, mods);
        }
    }

    protected void handleChangeToDirectory(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.addModification(new ContentModification(ContentModification.Type.MKDIR_TO_CLUSTER, rootName, modified));
        if (log.isTraceEnabled()) {
            log.trace((Object)("created " + (Object)((Object)ContentModification.Type.MKDIR_TO_CLUSTER) + " modification for " + modified.getRelativePath()));
        }
    }

    protected void handleAddition(String rootName, RepositoryItemMetadata modified, RepositoryItemMetadata base, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.handleAddition(rootName, modified, mods);
    }

    protected void handleChangeFromDirectory(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        ContentModification mod = new ContentModification(ContentModification.Type.PUSH_TO_CLUSTER, rootName, modified);
        mods.pushPreapprovedRemoveParent(mod);
        if (log.isTraceEnabled()) {
            log.trace((Object)("created " + (Object)((Object)ContentModification.Type.PUSH_TO_CLUSTER) + " modification for " + modified.getRelativePath()));
        }
    }

    protected void handleDirectoryTimestampModification(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.addModification(new ContentModification(ContentModification.Type.DIR_TIMESTAMP_MISMATCH, rootName, base));
        if (log.isTraceEnabled()) {
            log.trace((Object)("created " + (Object)((Object)ContentModification.Type.DIR_TIMESTAMP_MISMATCH) + " modification for " + base.getRelativePath()));
        }
    }

    protected void handleSimpleModification(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, AbstractContentModificationGenerator.GeneratedModifications mods) {
        this.drainPreapprovedRemovals(mods);
        mods.addModification(new ContentModification(ContentModification.Type.PUSH_TO_CLUSTER, rootName, modified));
        if (log.isTraceEnabled()) {
            log.trace((Object)("created " + (Object)((Object)ContentModification.Type.PUSH_TO_CLUSTER) + " modification for " + modified.getRelativePath()));
        }
    }

    protected void handleRemoval(String rootName, RepositoryItemMetadata item, AbstractContentModificationGenerator.GeneratedModifications mods) {
        ContentModification removedParent = mods.peekPreapprovedRemoveParent();
        while (removedParent != null && !item.isChildOf(removedParent.getItem())) {
            mods.addModification(mods.popPreapprovedRemoveParent());
            removedParent = mods.peekPreapprovedRemoveParent();
        }
        ContentModification removal = new ContentModification(ContentModification.Type.REMOVE_TO_CLUSTER, rootName, item);
        if (item.isDirectory()) {
            mods.addModification(new ContentModification(ContentModification.Type.PREPARE_RMDIR_TO_CLUSTER, rootName, item));
            mods.pushPreapprovedRemoveParent(removal);
            if (log.isTraceEnabled()) {
                log.trace((Object)("created " + (Object)((Object)ContentModification.Type.PREPARE_RMDIR_TO_CLUSTER) + " modification for " + item.getRelativePath()));
            }
        } else {
            mods.addModification(removal);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("created " + (Object)((Object)ContentModification.Type.REMOVE_TO_CLUSTER) + " modification for " + item.getRelativePath()));
        }
    }
}

