/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.MessageHandler;

abstract class AbstractMessageHandler
implements MessageHandler {
    protected final RemoteConnection remoteConnection;

    protected AbstractMessageHandler(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
    }

    public void handleEof() {
        try {
            this.remoteConnection.getChannel().shutdownReads();
            return;
        }
        catch (IOException e) {
            Loggers.main.trace((Throwable)e, "Failed to shut down reads for %s", (Object)this.remoteConnection);
            IoUtils.safeClose((Closeable)this.remoteConnection);
            return;
        }
    }

    public void handleException(IOException e) {
        if (e instanceof ClosedChannelException) {
            return;
        }
        Loggers.main.trace((Throwable)e, "Received exception from %s", (Object)this.remoteConnection);
        IoUtils.safeClose((Closeable)this.remoteConnection);
    }
}

