/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.NioByteOutput;
import org.jboss.remoting3.remote.OutboundStream;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.stream.ObjectSource;
import org.jboss.xnio.IoUtils;

final class OutboundObjectSourceTransmitTask
implements Runnable {
    private final ObjectSource objectSource;
    private final OutboundStream outboundStream;
    private final RemoteConnectionHandler connectionHandler;

    OutboundObjectSourceTransmitTask(ObjectSource objectSource, OutboundStream outboundStream, RemoteConnectionHandler connectionHandler) {
        this.objectSource = objectSource;
        this.outboundStream = outboundStream;
        this.connectionHandler = connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ObjectSource objectSource = this.objectSource;
        try {
            MarshallerFactory marshallerFactory = this.connectionHandler.getMarshallerFactory();
            MarshallingConfiguration configuration = this.connectionHandler.getMarshallingConfiguration();
            try {
                Marshaller marshaller = marshallerFactory.createMarshaller(configuration);
                try {
                    marshaller.start((ByteOutput)new NioByteOutput(new NioByteOutput.BufferWriter(){

                        public ByteBuffer getBuffer() {
                            return OutboundObjectSourceTransmitTask.this.outboundStream.getBuffer();
                        }

                        public void accept(ByteBuffer buffer, boolean eof) throws IOException {
                            OutboundObjectSourceTransmitTask.this.outboundStream.send(buffer);
                            if (eof) {
                                OutboundObjectSourceTransmitTask.this.outboundStream.sendEof();
                            }
                        }

                        public void flush() throws IOException {
                        }
                    }));
                    while (objectSource.hasNext()) {
                        marshaller.writeByte(0);
                        marshaller.writeObject(objectSource.next());
                    }
                    marshaller.writeByte(1);
                    marshaller.finish();
                    marshaller.close();
                }
                finally {
                    IoUtils.safeClose((Closeable)marshaller);
                }
            }
            catch (Exception e) {
                this.outboundStream.sendException();
            }
        }
        finally {
            IoUtils.safeClose((Closeable)objectSource);
        }
    }
}

