/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMTerminateSequence;

final class RMTerminateSequenceSerializer
implements RMSerializer {
    private static final RMSerializer INSTANCE = new RMTerminateSequenceSerializer();

    private RMTerminateSequenceSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMTerminateSequence o = (RMTerminateSequence)object;
        try {
            SOAPBody soapBody = soapMessage.getSOAPPart().getEnvelope().getBody();
            RMConstants wsrmConstants = provider.getConstants();
            QName terminateSequenceQName = wsrmConstants.getTerminateSequenceQName();
            SOAPElement terminateSequenceElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapBody, terminateSequenceQName, "soap body");
            QName identifierQName = wsrmConstants.getIdentifierQName();
            SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(terminateSequenceElement, identifierQName, terminateSequenceQName);
            String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
            o.setIdentifier(identifier);
            QName lastMsgNumberQName = wsrmConstants.getLastMsgNumberQName();
            SOAPElement lastMsgNumberElement = RMSerializationHelper.getOptionalElement(terminateSequenceElement, lastMsgNumberQName, terminateSequenceQName);
            if (lastMsgNumberElement != null) {
                String lastMsgNumberString = RMSerializationHelper.getRequiredTextContent(lastMsgNumberElement, lastMsgNumberQName);
                long lastMsgNumberValue = RMSerializationHelper.stringToLong(lastMsgNumberString, "Unable to parse LastMsgNumber element text content");
                o.setLastMsgNumber(lastMsgNumberValue);
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    @Override
    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMTerminateSequence o = (RMTerminateSequence)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName terminateSequenceQName = wsrmConstants.getTerminateSequenceQName();
            SOAPElement terminateSequenceElement = soapEnvelope.getBody().addChildElement(terminateSequenceQName);
            QName identifierQName = wsrmConstants.getIdentifierQName();
            terminateSequenceElement.addChildElement(identifierQName).setValue(o.getIdentifier());
            if (o.getLastMsgNumber() != 0L) {
                QName lastMsgNumberQName = wsrmConstants.getLastMsgNumberQName();
                SOAPElement lastMsgNumberElement = terminateSequenceElement.addChildElement(lastMsgNumberQName);
                lastMsgNumberElement.setValue(String.valueOf(o.getLastMsgNumber()));
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

