/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.util.JBossStringBuilder;

@XmlType(name="installType", propOrder={"annotations", "parameters"})
public class AbstractInstallMetaData
extends AbstractLifecycleMetaData
implements InstallMetaData,
Serializable {
    private static final long serialVersionUID = 2L;
    protected String bean;
    protected ControllerState dependentState = ControllerState.INSTALLED;

    public AbstractInstallMetaData() {
        this.setState(ControllerState.INSTALLED);
    }

    public String getBean() {
        return this.bean;
    }

    @XmlAttribute
    public void setBean(String bean) {
        this.bean = bean;
    }

    @XmlAttribute(name="state")
    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        if (this.getMethodName() == null) {
            throw new IllegalArgumentException("Install/uninstall should have method attribute.");
        }
        KernelControllerContext context = visitor.getControllerContext();
        if (this.bean != null) {
            InstallationDependencyItem item = new InstallationDependencyItem(context.getName(), this.bean, this.state, this.dependentState);
            visitor.addDependency((DependencyItem)item);
        }
        super.initialVisit(visitor);
    }

    protected ClassInfo getClassInfo(KernelControllerContext context) throws Throwable {
        if (this.bean != null) {
            KernelController controller = (KernelController)context.getController();
            ControllerContext beanContext = controller.getContext(this.bean, ControllerState.INSTANTIATED);
            if (beanContext != null) {
                Object target = beanContext.getTarget();
                KernelConfigurator configurator = controller.getKernel().getConfigurator();
                return configurator.getClassInfo(target.getClass());
            }
            throw new IllegalArgumentException("Cannot determine install bean class: " + beanContext + " on " + this);
        }
        return super.getClassInfo(context);
    }

    public void toString(JBossStringBuilder buffer) {
        if (this.bean != null) {
            buffer.append("bean=").append(this.bean);
        }
        if (!ControllerState.INSTALLED.equals((Object)this.dependentState)) {
            buffer.append(" dependentState=" + this.dependentState);
        }
        buffer.append(" ");
        super.toString(buffer);
    }

    public void toShortString(JBossStringBuilder buffer) {
        if (this.bean != null) {
            buffer.append(this.bean).append(".");
        }
        if (this.methodName != null) {
            buffer.append(this.methodName);
        }
    }

    public AbstractInstallMetaData clone() {
        return (AbstractInstallMetaData)super.clone();
    }

    public static class InstallationDependencyItem
    extends AbstractDependencyItem {
        public InstallationDependencyItem(Object name, String bean, ControllerState state, ControllerState dependentState) {
            super(name, (Object)bean, state, dependentState);
        }
    }
}

