/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.beans.metadata.api.annotations.Constructor;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.kernel.plugins.annotations.AbstractConstructorParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.kernel.plugins.annotations.Jsr330InjectFilter;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.ParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr330InjectConstructorAnnotationPlugin
extends AbstractConstructorParameterAnnotationPlugin<Inject, AbstractConstructorMetaData> {
    public Jsr330InjectConstructorAnnotationPlugin(Map<Class<? extends Annotation>, Annotation2ValueMetaDataAdapter<? extends Annotation>> adapters) {
        super(Inject.class, adapters);
    }

    @Override
    protected boolean checkAnnotatedInfo(ElementType type) {
        return ElementType.CONSTRUCTOR == type;
    }

    @Override
    protected boolean isMetaDataAlreadyPresent(ConstructorInfo info, Constructor annotation, BeanMetaData beanMetaData) {
        return beanMetaData.getConstructor() != null;
    }

    @Override
    protected ParameterInfo[] getParameters(ConstructorInfo info) {
        return info.getParameters();
    }

    @Override
    protected List<MetaDataVisitorNode> handleParameterlessInfo(ConstructorInfo info, Inject annotation, BeanMetaData beanMetaData) {
        return null;
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ConstructorInfo info, MetaData retrieval, Inject annotation, KernelControllerContext context) throws Throwable {
        if (!Jsr330InjectFilter.INSTANCE.handleInject(retrieval)) {
            return null;
        }
        ParameterInfo[] params = info.getParameters();
        if (params.length == 0) {
            return null;
        }
        if (!(context.getBeanMetaData() instanceof AbstractBeanMetaData)) {
            throw new IllegalStateException("Bean meta data is not AbstractBeanMetaData");
        }
        AbstractBeanMetaData beanMetaData = (AbstractBeanMetaData)context.getBeanMetaData();
        AbstractConstructorMetaData cmd = null;
        if (beanMetaData.getConstructor() == null) {
            cmd = new AbstractConstructorMetaData();
            beanMetaData.setConstructor(cmd);
        } else {
            if (!(beanMetaData.getConstructor() instanceof AbstractConstructorMetaData)) {
                throw new IllegalStateException("Constructor is not AbstractConstructorMetaData");
            }
            cmd = (AbstractConstructorMetaData)beanMetaData.getConstructor();
        }
        List<ParameterMetaData> parameters = cmd.getParameters();
        if (parameters == null) {
            parameters = new ArrayList<ParameterMetaData>();
            cmd.setParameters(parameters);
        }
        for (int i = 0; i < params.length; ++i) {
            AbstractInjectionValueMetaData inject = new AbstractInjectionValueMetaData();
            AbstractParameterMetaData param = new AbstractParameterMetaData(params[i].getParameterType().getName(), inject);
            parameters.add(param);
        }
        return Collections.singletonList(cmd);
    }

    @Override
    protected void setParameterizedMetaData(AbstractConstructorMetaData parameterizedMetaData, BeanMetaData beanMetaData) {
    }
}

