/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.cache.Cache;
import org.jboss.metadata.plugins.cache.CacheFactory;
import org.jboss.metadata.plugins.cache.CacheItem;
import org.jboss.metadata.plugins.cache.CachePolicyFactory;
import org.jboss.util.CachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachePolicyCacheFactory
implements CacheFactory {
    private static final Logger log = Logger.getLogger(CachePolicyCacheFactory.class);
    private CachePolicyFactory factory;
    private List<CachePolicy> policies;

    public CachePolicyCacheFactory(CachePolicyFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        this.factory = factory;
        this.policies = new ArrayList<CachePolicy>();
    }

    @Override
    public String createFqn(Object owner) {
        return null;
    }

    protected CachePolicy createCachePolicy() {
        try {
            CachePolicy policy = this.factory.createCachePolicy();
            policy.create();
            policy.start();
            this.policies.add(policy);
            return policy;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public <K, V> Cache<K, V> createCache(Class<K> keyClass, Class<V> valueClass, String rootFqn) {
        return new CachePolicyCache(this.createCachePolicy());
    }

    @Override
    public <V> CacheItem<V> createCacheItem(Class<V> valueClass, String rootFqn) {
        return new CachePolicyCacheItem(this.createCachePolicy());
    }

    public void stop() {
        ListIterator<CachePolicy> iter = this.policies.listIterator(this.policies.size());
        while (iter.hasPrevious()) {
            CachePolicy policy = iter.previous();
            try {
                policy.stop();
            }
            catch (Throwable t) {
                log.debug((Object)("Exception while stopping policy: " + policy + ", problem: " + t));
            }
        }
    }

    public void destroy() {
        ListIterator<CachePolicy> iter = this.policies.listIterator(this.policies.size());
        while (iter.hasPrevious()) {
            CachePolicy policy = iter.previous();
            try {
                policy.destroy();
            }
            catch (Throwable t) {
                log.debug((Object)("Exception while destroying policy: " + policy + ", problem: " + t));
            }
        }
        this.policies.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachePolicyCacheItem<V>
    extends CachePolicyCache<Object, V>
    implements CacheItem<V> {
        private static final Object KEY = "<KEY>";

        private CachePolicyCacheItem(CachePolicy policy) {
            super(policy);
        }

        @Override
        public V put(V value) {
            return this.put(KEY, value);
        }

        @Override
        public V get() {
            return this.get(KEY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachePolicyCache<K, V>
    implements Cache<K, V> {
        private CachePolicy policy;

        private CachePolicyCache(CachePolicy policy) {
            if (policy == null) {
                throw new IllegalArgumentException("Null policy");
            }
            this.policy = policy;
        }

        @Override
        public V put(K key, V value) {
            Object old = this.policy.get(key);
            this.policy.insert(key, value);
            return (V)old;
        }

        @Override
        public V get(K key) {
            return (V)this.policy.get(key);
        }

        @Override
        public V remove(K key) {
            Object old = this.policy.get(key);
            this.policy.remove(key);
            return (V)old;
        }

        @Override
        public void clear() {
            this.policy.flush();
        }
    }
}

