/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Merger;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=false)
public class MergerTest {
    private static final Address a = Util.createRandomAddress("A");
    private static final Address b = Util.createRandomAddress("B");
    private static final Address c = Util.createRandomAddress("C");
    private static final Address d = Util.createRandomAddress("D");
    private static final Address e = Util.createRandomAddress("E");
    private static final Address f = Util.createRandomAddress("F");

    public void testSimpleMerge() {
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, MergerTest.makeView(a, a, b));
        map.put(b, MergerTest.makeView(a, a, b));
        map.put(c, MergerTest.makeView(c, c, d));
        map.put(d, MergerTest.makeView(c, c, d));
        System.out.println("map:\n" + MergerTest.print(map));
        assert (map.size() == 4);
        Merger.sanitizeViews(map);
        System.out.println("map after sanitization:\n" + MergerTest.print(map));
        assert (map.size() == 4);
        assert (((View)map.get(a)).size() == 2);
        assert (((View)map.get(b)).size() == 2);
        assert (((View)map.get(c)).size() == 2);
        assert (((View)map.get(d)).size() == 2);
    }

    public void testOverlappingMerge() {
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, MergerTest.makeView(a, a, b, c));
        map.put(b, MergerTest.makeView(b, b, c));
        map.put(c, MergerTest.makeView(b, b, c));
        System.out.println("map:\n" + MergerTest.print(map));
        assert (map.size() == 3);
        Merger.sanitizeViews(map);
        System.out.println("map after sanitization:\n" + MergerTest.print(map));
        assert (map.size() == 3);
        assert (((View)map.get(a)).size() == 1);
        assert (((View)map.get(b)).size() == 2);
        assert (((View)map.get(c)).size() == 2);
    }

    public void testOverlappingMerge2() {
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, MergerTest.makeView(a, a, b));
        map.put(b, MergerTest.makeView(b, b));
        System.out.println("map:\n" + MergerTest.print(map));
        assert (map.size() == 2);
        Merger.sanitizeViews(map);
        System.out.println("map after sanitization:\n" + MergerTest.print(map));
        assert (map.size() == 2);
        assert (((View)map.get(a)).size() == 1);
        assert (((View)map.get(b)).size() == 1);
    }

    public void testOverlappingMerge3() {
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, MergerTest.makeView(a, a, b));
        map.put(b, MergerTest.makeView(b, b, c));
        map.put(c, MergerTest.makeView(c, c, d));
        map.put(d, MergerTest.makeView(d, d, e));
        System.out.println("map:\n" + MergerTest.print(map));
        assert (map.size() == 4);
        Merger.sanitizeViews(map);
        System.out.println("map after sanitization:\n" + MergerTest.print(map));
        assert (map.size() == 4);
        assert (((View)map.get(a)).size() == 1);
        assert (((View)map.get(b)).size() == 1);
        assert (((View)map.get(c)).size() == 1);
        assert (((View)map.get(d)).size() == 2);
    }

    private static <T> Collection<T> makeList(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    private static View makeView(Address coord, Address ... members) {
        return new View(coord, 1L, new Vector<Address>(Arrays.asList(members)));
    }

    static String print(Map<Address, View> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, View> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue().getMembers()).append("\n");
        }
        return sb.toString();
    }
}

