/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.mbean.spi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.DefaultValueBuilderFactory;
import org.jboss.managed.api.annotation.FieldsFactory;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementPropertyFactory;
import org.jboss.managed.api.annotation.ManagementRuntimeRef;
import org.jboss.managed.api.annotation.Masked;
import org.jboss.managed.api.annotation.RunStateProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedOperationImpl;
import org.jboss.managed.plugins.ManagedParameterImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.metatype.api.annotations.MetaMappingFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.spi.values.DefaultValueBuilder;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.metatype.spi.values.MetaMapperFactory;
import org.jboss.profileservice.management.MBeanRuntimeComponentDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanManagedObjectFactory {
    private static Logger log = Logger.getLogger(MBeanManagedObjectFactory.class);
    private MetaTypeFactory metaTypeFactory = MetaTypeFactory.getInstance();

    public MetaTypeFactory getMetaTypeFactory() {
        return this.metaTypeFactory;
    }

    public void setMetaTypeFactory(MetaTypeFactory metaTypeFactory) {
        this.metaTypeFactory = metaTypeFactory;
    }

    public ManagedObject getManagedObject(ObjectName mbean, MBeanInfo info, ClassLoader mbeanLoader, MetaData metaData) throws Exception {
        return this.getManagedObject(mbean, info, mbeanLoader, metaData, null, null);
    }

    public ManagedObject getManagedObject(ObjectName mbean, MBeanInfo info, ClassLoader mbeanLoader, MetaData metaData, ViewUse[] defaultViewUse, Map<String, String> propertyMetaMappings) throws Exception {
        MBeanAttributeInfo[] attributes;
        boolean trace = log.isTraceEnabled();
        boolean isRuntime = false;
        String name = mbean.getCanonicalName();
        String nameType = null;
        String attachmentName = null;
        Class moFieldsFactory = null;
        Class moPropertyFactory = null;
        HashSet<ManagedProperty> properties = new HashSet<ManagedProperty>();
        for (MBeanAttributeInfo propertyInfo : attributes = info.getAttributes()) {
            boolean includeProperty;
            ManagementProperty managementProperty = this.getAnnotation(ManagementProperty.class, propertyInfo, metaData);
            ManagementObjectID id = this.getAnnotation(ManagementObjectID.class, propertyInfo, metaData);
            ManagementObjectRef ref = this.getAnnotation(ManagementObjectRef.class, propertyInfo, metaData);
            ManagementRuntimeRef runtimeRef = this.getAnnotation(ManagementRuntimeRef.class, propertyInfo, metaData);
            RunStateProperty rsp = this.getAnnotation(RunStateProperty.class, propertyInfo, metaData);
            Masked masked = this.getAnnotation(Masked.class, propertyInfo, metaData);
            DefaultValueBuilderFactory defaultsFactory = this.getAnnotation(DefaultValueBuilderFactory.class, propertyInfo, metaData);
            HashMap<String, Object> propAnnotations = new HashMap<String, Object>();
            if (managementProperty != null) {
                propAnnotations.put(ManagementProperty.class.getName(), managementProperty);
            }
            if (id != null) {
                propAnnotations.put(ManagementObjectID.class.getName(), id);
                nameType = id.type();
            }
            if (ref != null) {
                propAnnotations.put(ManagementObjectRef.class.getName(), ref);
            }
            if (runtimeRef != null) {
                propAnnotations.put(ManagementRuntimeRef.class.getName(), runtimeRef);
            }
            if (rsp != null) {
                propAnnotations.put(RunStateProperty.class.getName(), rsp);
            }
            if (masked != null) {
                propAnnotations.put(Masked.class.getName(), masked);
            }
            if (includeProperty = propertyInfo.isReadable() | propertyInfo.isWritable()) {
                String defaultValue;
                boolean readOnly;
                Fields fields = null;
                Class factory = moFieldsFactory;
                FieldsFactory ff = this.getAnnotation(FieldsFactory.class, propertyInfo, metaData);
                if (ff != null) {
                    factory = ff.value();
                }
                if (factory != null) {
                    try {
                        fields = (Fields)factory.newInstance();
                    }
                    catch (Exception e) {
                        log.debug((Object)"Failed to created Fields", (Throwable)e);
                    }
                }
                if (fields == null) {
                    fields = new DefaultFieldsImpl();
                }
                if (propertyInfo instanceof Serializable) {
                    Serializable pinfo = (Serializable)Serializable.class.cast(propertyInfo);
                    fields.setField("propertyInfo", (Object)pinfo);
                }
                String propertyName = propertyInfo.getName();
                if (managementProperty != null) {
                    propertyName = managementProperty.name();
                }
                if (propertyName.length() == 0) {
                    propertyName = propertyInfo.getName();
                }
                fields.setField("name", (Object)propertyName);
                String mappedName = propertyInfo.getName();
                if (managementProperty != null) {
                    mappedName = managementProperty.mappedName();
                }
                if (mappedName.length() == 0) {
                    mappedName = propertyInfo.getName();
                }
                fields.setField("mappedName", (Object)mappedName);
                String description = "%Generated%";
                if (managementProperty != null) {
                    description = managementProperty.description();
                }
                if (description.equals("%Generated%")) {
                    description = propertyName;
                }
                fields.setField("description", (Object)description);
                if (trace) {
                    log.trace((Object)("Building MangedProperty(name=" + propertyName + ",mappedName=" + mappedName + ") ,annotations=" + propAnnotations));
                }
                boolean mandatory = false;
                if (managementProperty != null) {
                    mandatory = managementProperty.mandatory();
                }
                if (mandatory) {
                    fields.setField("mandatory", (Object)Boolean.TRUE);
                }
                boolean bl = readOnly = !propertyInfo.isWritable();
                if (!readOnly && managementProperty != null) {
                    readOnly = managementProperty.readOnly();
                }
                if (readOnly) {
                    fields.setField("readOnly", (Object)Boolean.TRUE);
                }
                boolean managed = false;
                if (managementProperty != null) {
                    managed = managementProperty.managed();
                }
                if (managementProperty != null) {
                    ViewUse[] use = managementProperty.use();
                    fields.setField("viewUse", (Object)use);
                } else if (defaultViewUse != null) {
                    fields.setField("viewUse", (Object)defaultViewUse);
                }
                ActivationPolicy apolicy = ActivationPolicy.IMMEDIATE;
                if (managementProperty != null) {
                    apolicy = managementProperty.activationPolicy();
                }
                fields.setField("activationPolicy", (Object)apolicy);
                MetaMapper[] mapperReturn = new MetaMapper[]{null};
                String propertyType = propertyInfo.getType();
                Object metaType = null;
                Class<?> type = null;
                try {
                    type = this.loadTypeClass(propertyType, mbeanLoader);
                    metaType = this.getMetaType(propertyInfo, type, metaData, false, propertyMetaMappings, mapperReturn);
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to create ManagedProperty on failure to load type:" + propertyType + ", for property: " + propertyInfo.getName()));
                    continue;
                }
                if (metaType == null) {
                    metaType = managed ? (type.isArray() ? new ArrayMetaType(1, (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) : (Collection.class.isAssignableFrom(type) ? new CollectionMetaType(type.getName(), (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) : AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE)) : this.metaTypeFactory.resolve(type);
                }
                fields.setField("metaType", metaType);
                if (managementProperty != null && (defaultValue = managementProperty.defaultValue()).length() > 0) {
                    try {
                        DefaultValueBuilder builder = null;
                        if (defaultsFactory != null) {
                            Class factoryClass = defaultsFactory.value();
                            builder = (DefaultValueBuilder)factoryClass.newInstance();
                        }
                        if (builder != null) {
                            MetaValue defaultMV = builder.buildMetaValue(defaultValue);
                            if (defaultMV != null) {
                                fields.setField("defaultValue", (Object)defaultMV);
                            }
                        } else {
                            log.warn((Object)("Failed to find DefaultValueBuilder for type: " + metaType));
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to create default value for: " + propertyInfo), (Throwable)e);
                    }
                }
                if (!propAnnotations.isEmpty()) {
                    fields.setField("annotations", propAnnotations);
                }
                ManagedProperty property = null;
                Class mpClass = moPropertyFactory;
                ManagementPropertyFactory mpf = this.getAnnotation(ManagementPropertyFactory.class, propertyInfo, metaData);
                if (mpf != null) {
                    mpClass = mpf.value();
                }
                if (mpClass != null) {
                    property = AbstractManagedObjectFactory.createManagedProperty((Class)mpClass, (Fields)fields);
                }
                if (property == null) {
                    property = new ManagedPropertyImpl(fields);
                }
                if (mapperReturn[0] != null) {
                    property.setTransientAttachment(MetaMapper.class.getName(), (Object)mapperReturn[0]);
                }
                properties.add(property);
                continue;
            }
            if (!trace) continue;
            log.trace((Object)("Ignoring property: " + propertyInfo));
        }
        HashSet<ManagedOperation> operations = new HashSet<ManagedOperation>();
        MBeanOperationInfo[] methodInfos = info.getOperations();
        if (methodInfos != null && methodInfos.length > 0) {
            for (MBeanOperationInfo methodInfo : methodInfos) {
                ManagementOperation managementOp = this.getAnnotation(ManagementOperation.class, methodInfo, metaData);
                try {
                    ManagedOperation op = this.getManagedOperation(methodInfo, managementOp, mbeanLoader, metaData);
                    operations.add(op);
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to create ManagedOperation for: " + methodInfo.getName()), (Throwable)e);
                }
            }
        }
        ManagedObjectImpl result = new ManagedObjectImpl(mbean.getCanonicalName(), properties);
        Map empty = Collections.emptyMap();
        result.setAnnotations(empty);
        result.setComponentName((Object)name);
        if (nameType != null) {
            result.setNameType(nameType);
        }
        if (attachmentName != null) {
            result.setAttachmentName(attachmentName);
        }
        if (operations.size() > 0) {
            result.setOperations(operations);
        }
        for (ManagedProperty property : properties) {
            property.setManagedObject((ManagedObject)result);
        }
        result.setTransientAttachment(MBeanInfo.class.getName(), (Object)info);
        result.setTransientAttachment(MBeanRuntimeComponentDispatcher.class.getName(), (Object)true);
        return result;
    }

    protected <X extends Annotation> X getAnnotation(Class<X> annotationType, MBeanFeatureInfo info, MetaData metaData) {
        Annotation annotation = null;
        if (metaData != null && (annotation = metaData.getAnnotation(annotationType)) == null && info instanceof DescriptorAccess) {
            DescriptorAccess daccess = (DescriptorAccess)((Object)info);
            Descriptor descriptor = daccess.getDescriptor();
            annotation = this.getAnnotation(annotationType, descriptor);
        }
        return (X)annotation;
    }

    protected <X extends Annotation> X getAnnotation(Class<X> annotationType, Descriptor descriptor) {
        return null;
    }

    protected MetaType getMetaType(MBeanFeatureInfo info, Type infoType, MetaData metaData, boolean useTypeFactory, Map<String, String> propertyMetaMappings, MetaMapper[] mapperReturn) {
        String className;
        MetaType returnType = null;
        MetaMapper metaMapper = null;
        MetaMapping metaMapping = this.getAnnotation(MetaMapping.class, info, metaData);
        MetaMappingFactory metaMappingFactory = this.getAnnotation(MetaMappingFactory.class, info, metaData);
        if (metaMappingFactory != null) {
            Class mmfClass = metaMappingFactory.value();
            try {
                MetaMapperFactory mmf = (MetaMapperFactory)mmfClass.newInstance();
                String[] args = metaMappingFactory.args();
                metaMapper = args.length > 0 ? mmf.newInstance(args) : mmf.newInstance();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to create MetaMapperFactory: " + metaMappingFactory), (Throwable)e);
            }
        }
        if (metaMapping != null) {
            Class mapperClass = metaMapping.value();
            try {
                metaMapper = (MetaMapper)mapperClass.newInstance();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to create MetaMapper: " + metaMapping), (Throwable)e);
            }
        }
        if (info instanceof MBeanAttributeInfo && propertyMetaMappings != null && (className = propertyMetaMappings.get(info.getName())) != null) {
            try {
                metaMapper = (MetaMapper)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to create MetaMapper: " + className + " for property: " + info.getName()));
            }
        }
        if (metaMapper != null) {
            returnType = metaMapper.getMetaType();
            if (mapperReturn != null && mapperReturn.length > 0) {
                mapperReturn[0] = metaMapper;
            }
        }
        if (returnType == null && useTypeFactory) {
            returnType = this.metaTypeFactory.resolve(infoType);
        }
        return returnType;
    }

    protected ManagedOperation getManagedOperation(MBeanOperationInfo methodInfo, ManagementOperation opAnnotation, ClassLoader mbeanLoader, MetaData metaData) throws Exception {
        String name = methodInfo.getName();
        String description = opAnnotation != null ? opAnnotation.description() : name;
        ManagedOperation.Impact impact = ManagedOperation.Impact.Unknown;
        switch (methodInfo.getImpact()) {
            case 1: {
                impact = ManagedOperation.Impact.WriteOnly;
                break;
            }
            case 2: {
                impact = ManagedOperation.Impact.ReadWrite;
                break;
            }
            case 0: {
                impact = ManagedOperation.Impact.ReadOnly;
                break;
            }
            case 3: {
                impact = ManagedOperation.Impact.Unknown;
            }
        }
        MetaMapper[] returnTypeMapper = new MetaMapper[]{null};
        Class<?> returnTypeClass = this.loadTypeClass(methodInfo.getReturnType(), mbeanLoader);
        MetaType returnType = this.getMetaType(methodInfo, returnTypeClass, metaData, true, null, returnTypeMapper);
        ArrayList<ManagedParameterImpl> mparams = new ArrayList<ManagedParameterImpl>();
        MBeanParameterInfo[] paramInfo = methodInfo.getSignature();
        if (paramInfo != null) {
            for (int i = 0; i < paramInfo.length; ++i) {
                MBeanParameterInfo pinfo = paramInfo[i];
                String pname = pinfo.getName();
                String pdescription = pinfo.getDescription();
                if (pname == null) {
                    pname = "arg#" + i;
                }
                DefaultFieldsImpl fields = new DefaultFieldsImpl(pname);
                if (pdescription != null) {
                    fields.setField("description", (Object)pdescription);
                }
                MetaMapper[] paramMapper = new MetaMapper[]{null};
                Class<?> paramType = this.loadTypeClass(pinfo.getType(), mbeanLoader);
                MetaType metaType = this.getMetaType(pinfo, paramType, metaData, true, null, paramMapper);
                fields.setField("metaType", (Object)metaType);
                ManagedParameterImpl mp = new ManagedParameterImpl((Fields)fields);
                if (paramMapper[0] != null) {
                    mp.setTransientAttachment(MetaMapper.class.getName(), (Object)paramMapper[0]);
                }
                mparams.add(mp);
            }
        }
        ManagedParameter[] parameters = new ManagedParameter[mparams.size()];
        mparams.toArray(parameters);
        ManagedOperationImpl op = new ManagedOperationImpl(name, description, impact, parameters, returnType);
        if (returnTypeMapper[0] != null) {
            op.setTransientAttachment(MetaMapper.class.getName(), (Object)returnTypeMapper[0]);
        }
        return op;
    }

    protected Class<?> loadTypeClass(String propertyType, ClassLoader loader) throws ClassNotFoundException {
        Class<Object> type = null;
        type = propertyType.equals("byte") ? Byte.TYPE : (propertyType.equals("char") ? Character.TYPE : (propertyType.equals("short") ? Short.TYPE : (propertyType.equals("int") ? Integer.TYPE : (propertyType.equals("long") ? Long.TYPE : (propertyType.equals("float") ? Float.TYPE : (propertyType.equals("double") ? Double.TYPE : (propertyType.equals("void") ? Void.TYPE : (propertyType.equals("boolean") ? Boolean.TYPE : loader.loadClass(propertyType)))))))));
        return type;
    }
}

