/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.httpserver_httpspi;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.spi.http.HttpContext;
import javax.xml.ws.spi.http.HttpExchange;
import org.jboss.ws.httpserver_httpspi.AbstractWrappedOutputStream;
import org.jboss.ws.httpserver_httpspi.HttpContextDelegate;
import org.jboss.ws.httpserver_httpspi.PathUtils;

public class HttpExchangeDelegate
extends HttpExchange {
    private com.sun.net.httpserver.HttpExchange delegate;
    private HttpContextDelegate contextDelegate;
    private OutputStream wrappeddOutputStream;
    private int status;

    public HttpExchangeDelegate(com.sun.net.httpserver.HttpExchange delegate) {
        this.delegate = delegate;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.delegate.getRequestHeaders();
    }

    public String getRequestHeader(String name) {
        return this.delegate.getRequestHeaders().getFirst(name);
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.delegate.getResponseHeaders();
    }

    public void addResponseHeader(String name, String value) {
        this.delegate.getResponseHeaders().add(name, value);
    }

    public String getRequestURI() {
        return this.delegate.getRequestURI().toString();
    }

    public String getContextPath() {
        return PathUtils.getContextPath(this.delegate.getRequestURI());
    }

    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    public HttpContext getHttpContext() {
        if (this.contextDelegate == null) {
            this.contextDelegate = new HttpContextDelegate(this.delegate.getHttpContext(), PathUtils.getPath(this.delegate.getRequestURI()));
        }
        return this.contextDelegate;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public InputStream getRequestBody() throws IOException {
        return this.delegate.getRequestBody();
    }

    public OutputStream getResponseBody() throws IOException {
        if (this.wrappeddOutputStream == null) {
            this.wrappeddOutputStream = new AbstractWrappedOutputStream(){

                @Override
                protected void onFirstWrite() throws IOException {
                    if (HttpExchangeDelegate.this.status == 0) {
                        HttpExchangeDelegate.this.status = 200;
                    }
                    HttpExchangeDelegate.this.delegate.sendResponseHeaders(HttpExchangeDelegate.this.status, 0L);
                    this.wrappedStream = HttpExchangeDelegate.this.delegate.getResponseBody();
                }
            };
        }
        return this.wrappeddOutputStream;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    public String getScheme() {
        String scheme = this.delegate.getRequestURI().getScheme();
        if (scheme == null) {
            HttpServer server = this.delegate.getHttpContext().getServer();
            scheme = server instanceof HttpsServer ? "https" : "http";
        }
        return scheme;
    }

    public String getPathInfo() {
        return null;
    }

    public String getQueryString() {
        return this.delegate.getRequestURI().getQuery();
    }

    public Object getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        return this.delegate.getPrincipal();
    }

    public boolean isUserInRole(String role) {
        return false;
    }
}

