/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.util.HashMap;
import java.util.Map;

public class StopWatch {
    private long start;
    private long end;
    private Map markerMap;

    public StopWatch() {
        this.reset();
    }

    public void markTimeBegin(String marker) {
        if (this.markerMap.containsKey(marker)) {
            TimeSlice ts = (TimeSlice)this.markerMap.get(marker);
            ts.cont();
        } else {
            this.markerMap.put(marker, new TimeSlice(marker));
        }
    }

    public void markTimeEnd(String marker) {
        if (!this.markerMap.containsKey(marker)) {
            throw new IllegalArgumentException("Invalid marker");
        }
        TimeSlice ts = (TimeSlice)this.markerMap.get(marker);
        ts.setFinished();
    }

    public StopWatch(long start) {
        this.start = start;
        this.markerMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reset() {
        try {
            long l = this.getElapsed();
            return l;
        }
        finally {
            this.start = System.currentTimeMillis();
            this.markerMap = new HashMap();
        }
    }

    public long getElapsed() {
        this.end = System.currentTimeMillis();
        return this.end - this.start;
    }

    public String toString() {
        long elap = this.getElapsed();
        String fraction = elap % 1000L + "";
        int pad = 3 - fraction.length();
        StringBuffer buf = new StringBuffer().append(elap / 1000L).append('.');
        while (pad-- > 0) {
            buf.append("0");
        }
        buf.append(fraction);
        if (this.markerMap.size() > 0) {
            buf.append(" { Markers: ");
            for (TimeSlice ts : this.markerMap.values()) {
                ts.writeBuf(buf);
            }
            buf.append(" } ");
        }
        return buf.toString();
    }

    class TimeSlice {
        String marker;
        long begin;
        long end;

        public TimeSlice(String marker) {
            this.marker = marker;
            this.begin = this.end = System.currentTimeMillis();
        }

        public void setFinished() {
            this.end = System.currentTimeMillis();
        }

        public void cont() {
            this.begin -= this.end - this.begin;
        }

        public void writeBuf(StringBuffer buf) {
            long elap = this.end - this.begin;
            buf.append(" [").append(this.marker).append("=").append(elap / 1000L).append('.').append(elap % 1000L).append("] ");
        }
    }
}

