/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.vfs;

import java.net.URL;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.vfs.VFSResourceContext;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.AbstractVirtualFileFilterWithAttributes;

public class VFSResourceVisitor
extends AbstractVirtualFileFilterWithAttributes
implements VirtualFileVisitor {
    private VirtualFile[] roots;
    private VirtualFile[] excludedRoots;
    private VirtualFile root;
    private String rootPath;
    private String rootPathWithSlash;
    private ClassFilter included;
    private ClassFilter excluded;
    private ClassLoader classLoader;
    private ResourceVisitor visitor;
    private ResourceFilter filter;
    private ResourceFilter recurseFilter;

    public static void visit(VirtualFile[] roots, VirtualFile[] excludedRoots, ClassFilter included, ClassFilter excluded, ClassLoader classLoader, ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter, URL ... urls) {
        VFSResourceVisitor vfsVisitor = new VFSResourceVisitor(roots, excludedRoots, included, excluded, classLoader, visitor, filter, recurseFilter);
        for (VirtualFile root : roots) {
            try {
                if (urls != null && urls.length != 0 && !VFSResourceVisitor.matchRootWithUrls(root, urls)) continue;
                vfsVisitor.setRoot(root);
                root.visit((VirtualFileVisitor)vfsVisitor);
            }
            catch (Exception e) {
                throw new Error("Error visiting " + root, e);
            }
        }
    }

    protected static boolean matchRootWithUrls(VirtualFile root, URL[] urls) throws Exception {
        URL rootURL = root.toURL();
        for (URL url : urls) {
            if (ClassLoaderUtils.compareURL((URL)rootURL, (URL)url) != 0) continue;
            return true;
        }
        return false;
    }

    VFSResourceVisitor(VirtualFile[] roots, VirtualFile[] excludedRoots, ClassFilter included, ClassFilter excluded, ClassLoader classLoader, ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter) {
        if (roots == null) {
            throw new IllegalArgumentException("Null roots");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.roots = roots;
        this.excludedRoots = excludedRoots;
        this.included = included;
        this.excluded = excluded;
        this.classLoader = classLoader;
        this.visitor = visitor;
        this.filter = filter;
        this.recurseFilter = recurseFilter;
    }

    void setRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.root = root;
        this.rootPath = root.getPathName();
        this.rootPathWithSlash = this.rootPath + "/";
    }

    public VisitorAttributes getAttributes() {
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(false);
        attributes.setRecurseFilter((VirtualFileFilter)this);
        return attributes;
    }

    protected String determinePath(VirtualFile file) {
        String path = file.getPathName();
        if (path.equals(this.rootPath)) {
            path = "";
        } else if (path.startsWith(this.rootPathWithSlash)) {
            path = path.substring(this.rootPathWithSlash.length());
        }
        return path;
    }

    public boolean accepts(VirtualFile file) {
        if (this.recurseFilter != null) {
            try {
                String path = this.determinePath(file);
                VFSResourceContext resource = new VFSResourceContext(file, path, this.classLoader);
                if (!this.recurseFilter.accepts((ResourceContext)resource)) {
                    return false;
                }
            }
            catch (Exception e) {
                throw new Error("Error accepting " + file, e);
            }
        }
        if (file.equals(this.root)) {
            return true;
        }
        for (VirtualFile other : this.roots) {
            if (!file.equals(other)) continue;
            return false;
        }
        if (this.excludedRoots != null) {
            for (VirtualFile other : this.excludedRoots) {
                if (!file.equals(other)) continue;
                return false;
            }
        }
        return true;
    }

    public void visit(VirtualFile file) {
        try {
            if (file.isDirectory()) {
                return;
            }
            String path = this.determinePath(file);
            if (this.included != null && !this.included.matchesResourcePath(path)) {
                return;
            }
            if (this.excluded != null && this.excluded.matchesResourcePath(path)) {
                return;
            }
            VFSResourceContext resource = new VFSResourceContext(file, path, this.classLoader);
            resource.setRoot(this.root);
            if (this.filter == null || this.filter.accepts((ResourceContext)resource)) {
                this.visitor.visit((ResourceContext)resource);
            }
        }
        catch (Exception e) {
            throw new Error("Error visiting " + file, e);
        }
    }
}

