/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.client.spec.AnnotationMergedView;
import org.jboss.metadata.client.spec.ApplicationClient5MetaData;
import org.jboss.metadata.client.spec.ApplicationClientMetaData;

public class MergedJBossClientMetaDataDeployer
extends AbstractDeployer {
    public static final String CLIENT_MERGED_ATTACHMENT_NAME = "merged." + JBossClientMetaData.class.getName();

    public MergedJBossClientMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(ApplicationClientMetaData.class);
        this.addInput(JBossClientMetaData.class);
        this.addInput(AnnotationMetaDataDeployer.CLIENT_ANNOTATED_ATTACHMENT_NAME);
        this.setOutput(JBossClientMetaData.class);
        this.addOutput(CLIENT_MERGED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        ApplicationClientMetaData specMetaData = (ApplicationClientMetaData)unit.getAttachment(ApplicationClientMetaData.class);
        JBossClientMetaData metaData = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class);
        String key = AnnotationMetaDataDeployer.CLIENT_ANNOTATED_ATTACHMENT_NAME;
        ApplicationClient5MetaData annotatedMetaData = (ApplicationClient5MetaData)unit.getAttachment(key, ApplicationClient5MetaData.class);
        if (specMetaData == null && metaData == null && annotatedMetaData == null) {
            return;
        }
        if (annotatedMetaData != null) {
            if (specMetaData != null) {
                ApplicationClient5MetaData specMerged = new ApplicationClient5MetaData();
                AnnotationMergedView.merge((ApplicationClient5MetaData)specMerged, (ApplicationClientMetaData)specMetaData, (ApplicationClientMetaData)annotatedMetaData);
                specMetaData = specMerged;
            } else {
                specMetaData = annotatedMetaData;
            }
        }
        JBossClientMetaData mergedMetaData = new JBossClientMetaData();
        mergedMetaData.merge(metaData, specMetaData, false);
        unit.getTransientManagedObjects().addAttachment(JBossClientMetaData.class, (Object)mergedMetaData);
        unit.addAttachment(CLIENT_MERGED_ATTACHMENT_NAME, (Object)mergedMetaData, JBossClientMetaData.class);
    }
}

