/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JNDIBindingBean {
    private Logger log = Logger.getLogger(JNDIBindingBean.class);
    private String ctx = null;
    private Object beanObject = null;

    public void setBean(Object bean) {
        this.beanObject = bean;
    }

    public void setJNDIContext(String ctx) {
        this.ctx = ctx;
    }

    public void start() {
        if (this.beanObject == null) {
            throw new RuntimeException("Bean is null");
        }
        if (this.ctx == null) {
            throw new RuntimeException("JNDI Ctx name is null");
        }
        try {
            InitialContext ic = new InitialContext();
            ic.bind(this.ctx, this.beanObject);
            this.log.debug((Object)("Bound in JNDI:" + this.beanObject.getClass().getCanonicalName() + " in JNDI at " + this.ctx));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void create() {
    }

    public void destroy() {
    }

    public void stop() {
        try {
            InitialContext ic = new InitialContext();
            ic.unbind(this.ctx);
            this.log.debug((Object)("Unbound in JNDI:" + this.beanObject.getClass().getCanonicalName() + " in JNDI at " + this.ctx));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

