/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.deployment.AbstractDeploymentHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageflowDeploymentHandler
extends AbstractDeploymentHandler {
    private static LogProvider log = Logging.getLogProvider(PageflowDeploymentHandler.class);
    public static final String NAME = "org.jboss.seam.bpm.PageflowDeploymentHandler";
    private Set<String> pageflowDefinitions = new HashSet<String>();

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String name, ClassLoader classLoader) {
        if (name.endsWith(".jpdl.xml")) {
            InputStream inputStream = Resources.getResourceAsStream(name, null);
            try {
                Element root = XML.getRootElementSafely(inputStream);
                if ("pageflow-definition".equals(root.getName())) {
                    this.pageflowDefinitions.add(name);
                }
            }
            catch (DocumentException e) {
                log.debug("Unable to parse " + name, e);
            }
            finally {
                Resources.closeStream(inputStream);
            }
        }
    }

    public Set<String> getPageflowDefinitions() {
        return Collections.unmodifiableSet(this.pageflowDefinitions);
    }
}

