/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.ClassFile;
import org.jboss.seam.deployment.AbstractDeploymentHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDeploymentHandler
extends AbstractDeploymentHandler {
    public static final String NAME = "org.jboss.seam.deployment.AnnotationDeploymentHandler";
    public static final String ANNOTATIONS_KEY = "org.jboss.seam.deployment.annotationTypes";
    private Map<String, Set<Class<Object>>> classes;
    private Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
    private static final LogProvider log = Logging.getLogProvider(AnnotationDeploymentHandler.class);

    public AnnotationDeploymentHandler(List<String> annotationTypes, ClassLoader classLoader) {
        for (String string : annotationTypes) {
            try {
                this.annotations.add(classLoader.loadClass(string));
            }
            catch (ClassNotFoundException cnfe) {
                log.warn("could not load annotation class: " + string, cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                log.warn("could not load annotation class (missing dependency): " + string, ncdfe);
            }
            catch (ClassCastException cce) {
                log.warn("could not load annotation class (not an annotation): " + string, cce);
            }
        }
        this.classes = new HashMap<String, Set<Class<Object>>>();
        for (Class clazz : this.annotations) {
            this.classes.put(clazz.getName(), new HashSet());
        }
    }

    public Map<String, Set<Class<Object>>> getClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void handle(String name, ClassLoader classLoader) {
        if (name.endsWith(".class")) {
            String classname = AnnotationDeploymentHandler.filenameToClassname(name);
            try {
                ClassFile classFile = this.getClassFile(name, classLoader);
                Class<?> clazz = null;
                for (Class<? extends Annotation> annotationType : this.annotations) {
                    if (!this.hasAnnotation(classFile, annotationType)) continue;
                    log.trace("found class annotated with " + annotationType + ": " + name);
                    if (clazz == null) {
                        try {
                            clazz = classLoader.loadClass(classname);
                        }
                        catch (ClassNotFoundException cnfe) {
                            log.debug("could not load class: " + classname, cnfe);
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            log.debug("could not load class (missing dependency): " + classname, ncdfe);
                        }
                    }
                    this.classes.get(annotationType.getName()).add(clazz);
                }
            }
            catch (IOException ioe) {
                log.debug("could not load classfile: " + classname, ioe);
            }
        }
    }
}

