/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.sso;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.ManagerBase;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.JBossManager;
import org.jboss.web.tomcat.service.sso.JBossSingleSignOnEntry;
import org.jboss.web.tomcat.service.sso.spi.FullyQualifiedSessionId;
import org.jboss.web.tomcat.service.sso.spi.SSOClusterManager;
import org.jboss.web.tomcat.service.sso.spi.SSOCredentials;
import org.jboss.web.tomcat.service.sso.spi.SSOLocalManager;

public class ClusteredSingleSignOn
extends SingleSignOn
implements LifecycleListener,
SSOLocalManager {
    public static final int DEFAULT_PROCESS_EXPIRES_INTERVAL = 60;
    public static final int DEFAULT_MAX_EMPTY_LIFE = 1800;
    public static final String DEFAULT_CACHE_NAME = "clustered-sso";
    private static final Logger LOG = Logger.getLogger(ClusteredSingleSignOn.class);
    private volatile String clusterManagerClass;
    private volatile SSOClusterManager ssoClusterManager = null;
    private volatile String cacheConfigName = "clustered-sso";
    private volatile String threadPoolName = "jboss.system:service=ThreadPool";
    private Set activeManagers = Collections.synchronizedSet(new HashSet());
    private volatile int maxEmptyLife = 1800000;
    private volatile int processExpiresInterval = 60000;
    private volatile long lastProcessExpires = System.currentTimeMillis();
    private Map<String, Long> emptySSOs = new ConcurrentHashMap<String, Long>();
    private final Object MUTEX = new Object();

    public SSOClusterManager getClusterManager() {
        return this.ssoClusterManager;
    }

    public void setClusterManager(SSOClusterManager clusterManager) {
        if (this.started && clusterManager != this.ssoClusterManager) {
            throw new IllegalStateException("already started -- cannot set a new SSOClusterManager");
        }
        this.ssoClusterManager = clusterManager;
        if (clusterManager != null) {
            this.clusterManagerClass = clusterManager.getClass().getName();
        }
    }

    public String getClusterManagerClass() {
        return this.clusterManagerClass;
    }

    public void setClusterManagerClass(String managerClass) {
        if (!this.started) {
            this.clusterManagerClass = managerClass;
        } else if (this.ssoClusterManager == null) {
            try {
                this.createClusterManager(managerClass);
            }
            catch (LifecycleException e) {
                LOG.error((Object)("Exception creating SSOClusterManager " + managerClass), (Throwable)e);
            }
        } else {
            LOG.error((Object)("Cannot set clusterManagerClass to " + managerClass + "; already started using " + this.clusterManagerClass));
        }
    }

    @Deprecated
    public String getTreeCacheName() {
        return this.getCacheConfig();
    }

    @Deprecated
    public void setTreeCacheName(String cacheName) throws Exception {
        this.setCacheConfig(cacheName);
    }

    public String getCacheConfig() {
        return this.cacheConfigName;
    }

    public void setCacheConfig(String cacheConfig) {
        this.cacheConfigName = cacheConfig;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String poolName) throws Exception {
        this.threadPoolName = poolName;
    }

    public int getMaxEmptyLife() {
        return this.maxEmptyLife / 1000;
    }

    public void setMaxEmptyLife(int maxEmptyLife) {
        if (maxEmptyLife < 0) {
            throw new IllegalArgumentException("maxEmptyLife must be >= 0");
        }
        this.maxEmptyLife = maxEmptyLife * 1000;
    }

    public int getProcessExpiresInterval() {
        return this.processExpiresInterval / 1000;
    }

    public void setProcessExpiresInterval(int processExpiresInterval) {
        if (processExpiresInterval < 0) {
            throw new IllegalArgumentException("processExpiresInterval must be >= 0");
        }
        this.processExpiresInterval = processExpiresInterval * 1000;
    }

    public long getLastProcessExpires() {
        return this.lastProcessExpires;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ClusteredSSO:  starting, clusterManagerClass=" + this.clusterManagerClass + ", maxEmptyLife = " + this.maxEmptyLife + "ms, processExpiresInterval = " + this.processExpiresInterval + "ms"));
        }
        this.createClusterManager(this.clusterManagerClass);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.ssoClusterManager != null) {
            try {
                this.ssoClusterManager.start();
            }
            catch (LifecycleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LifecycleException("Caught exception starting " + this.clusterManagerClass, (Throwable)e);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        if (this.ssoClusterManager != null) {
            try {
                this.ssoClusterManager.stop();
            }
            catch (LifecycleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LifecycleException("Caught exception stopping " + this.ssoClusterManager.getClass().getSimpleName(), (Throwable)e);
            }
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process session destroyed on " + session));
        }
        String ssoId = null;
        Map map = this.reverse;
        synchronized (map) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("ignoring as SSO is already closed for session " + session));
            }
            return;
        }
        try {
            boolean stopped = false;
            boolean timedOut = this.isSessionTimedOut(session);
            if (timedOut || (stopped = this.isManagerStopped(session))) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("remove session " + session + " from SSO " + ssoId + ", isSessionTimedOut=" + timedOut + ", isManagerStopped=" + stopped));
                }
                this.removeSession(ssoId, session);
                this.processExpires();
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("user logged out of SSO " + ssoId));
                }
                this.logout(ssoId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Caught exception updating SSO " + ssoId + " following destruction of session " + session.getIdInternal()), (Throwable)e);
        }
    }

    private boolean isSessionTimedOut(Session session) {
        return session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getLastAccessedTime() >= (long)(session.getMaxInactiveInterval() * 1000);
    }

    private boolean isManagerStopped(Session session) {
        boolean stopped = false;
        Manager manager = session.getManager();
        if (manager instanceof ManagerBase) {
            ObjectName mgrName = ((ManagerBase)manager).getObjectName();
            stopped = !this.activeManagers.contains(mgrName);
        } else if (manager instanceof JBossManager) {
            ObjectName mgrName = ((JBossManager)manager).getObjectName();
            stopped = !this.activeManagers.contains(mgrName);
        } else if (manager instanceof Lifecycle) {
            stopped = !this.activeManagers.contains(manager);
        }
        return stopped;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source;
        boolean removed;
        String type = event.getType();
        if (("before_stop".equals(type) || "stop".equals(type) || "after_stop".equals(type)) && (removed = (source = event.getLifecycle()) instanceof ManagerBase ? this.activeManagers.remove(((ManagerBase)source).getObjectName()) : (source instanceof JBossManager ? this.activeManagers.remove(((JBossManager)source).getObjectName()) : this.activeManagers.remove(source)))) {
            source.removeLifecycleListener((LifecycleListener)this);
            LOG.debug((Object)("ClusteredSSO: removed stopped manager " + source.toString()));
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        JBossSingleSignOnEntry entry;
        request.removeNote("org.apache.catalina.request.SSOID");
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process request for '" + request.getRequestURI() + "'"));
        }
        if (request.getUserPrincipal() != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(" Principal '" + request.getUserPrincipal().getName() + "' has already been authenticated"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!Constants.SINGLE_SIGN_ON_COOKIE.equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)" SSO cookie is not present");
            }
            this.getNext().invoke(request, response);
            return;
        }
        String ssoId = cookie.getValue();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(" Checking for cached principal for " + ssoId));
        }
        if ((entry = this.getSingleSignOnEntry(cookie.getValue())) != null && this.isValid(ssoId, entry)) {
            Principal ssoPrinc = entry.getPrincipal();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(" Found cached principal '" + (ssoPrinc == null ? "NULL" : ssoPrinc.getName()) + "' with auth type '" + entry.getAuthType() + "'"));
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            if (!this.getRequireReauthentication() && ssoPrinc != null) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(ssoPrinc);
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Associate sso id " + ssoId + " with session " + session));
        }
        JBossSingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        boolean added = false;
        if (sso != null) {
            added = sso.addSession2(this, session);
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.put(session, ssoId);
        }
        if (added) {
            Manager manager = session.getManager();
            ObjectName mgrKey = null;
            if (manager instanceof ManagerBase) {
                mgrKey = ((ManagerBase)manager).getObjectName();
            } else if (manager instanceof JBossManager) {
                mgrKey = ((JBossManager)manager).getObjectName();
            } else if (manager instanceof Lifecycle) {
                mgrKey = manager;
            } else {
                LOG.warn((Object)("Manager for session " + session.getIdInternal() + " does not implement Lifecycle; web app shutdown may " + " lead to incorrect SSO invalidations"));
            }
            if (mgrKey != null) {
                Set set = this.activeManagers;
                synchronized (set) {
                    if (!this.activeManagers.contains(mgrKey)) {
                        this.activeManagers.add(mgrKey);
                        ((Lifecycle)manager).addLifecycleListener((LifecycleListener)this);
                    }
                }
            }
            if (this.ssoClusterManager != null) {
                this.ssoClusterManager.addSession(ssoId, this.getFullyQualifiedSessionId(session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        JBossSingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso == null) {
            return;
        }
        boolean removed = sso.removeSession2(session);
        if (this.ssoClusterManager != null) {
            if (removed) {
                this.ssoClusterManager.removeSession(ssoId, this.getFullyQualifiedSessionId(session));
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("deregister will notify cluster of removed session " + session + " sso id " + ssoId));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("deregister didn't find session " + session + " sso id " + ssoId + " cluster notification not sent"));
            }
        }
        if (sso.getSessionCount() == 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("deregister detected zero sessions for sso id " + ssoId));
            }
            Map map2 = this.cache;
            synchronized (map2) {
                sso = (JBossSingleSignOnEntry)((Object)this.cache.remove(ssoId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String ssoId) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Deregistering sso id '" + ssoId + "'"));
        }
        this.emptySSOs.remove(ssoId);
        JBossSingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (JBossSingleSignOnEntry)((Object)this.cache.remove(ssoId));
        }
        if (sso == null) {
            return;
        }
        Session[] sessions = sso.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(" Invalidating session " + sessions[i]));
            }
            Map map2 = this.reverse;
            synchronized (map2) {
                this.reverse.remove(sessions[i]);
            }
            sessions[i].expire();
        }
    }

    protected void logout(String ssoId) {
        this.deregister(ssoId);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.logout(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JBossSingleSignOnEntry getSingleSignOnEntry(String ssoId) {
        SSOCredentials credentials;
        JBossSingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso == null && this.ssoClusterManager != null && (credentials = this.ssoClusterManager.lookup(ssoId)) != null) {
            sso = new JBossSingleSignOnEntry(null, credentials.getAuthType(), credentials.getUsername(), credentials.getPassword());
            Map map = this.cache;
            synchronized (map) {
                this.cache.put(ssoId, sso);
            }
        }
        return sso;
    }

    public boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        JBossSingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
            entry.setPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    public void register(String ssoId, Principal principal, String authType, String username, String password) {
        this.registerLocal(ssoId, principal, authType, username, password);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.register(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        JBossSingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing session " + session.toString() + " from sso id " + ssoId + ", " + (entry != null ? "found SSO entry" : "SSO entry not found")));
        }
        if (entry == null) {
            return;
        }
        boolean removed = entry.removeSession2(session);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing Session " + session.toString() + ", session found =" + removed + ", ssoClusterManager is " + (this.ssoClusterManager != null ? "set" : "not set")));
        }
        if (removed && this.ssoClusterManager != null) {
            this.ssoClusterManager.removeSession(ssoId, this.getFullyQualifiedSessionId(session));
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
    }

    public void update(String ssoId, Principal principal, String authType, String username, String password) {
        boolean needToBroadcast = this.updateLocal(ssoId, principal, authType, username, password);
        if (needToBroadcast && this.ssoClusterManager != null) {
            this.ssoClusterManager.updateCredentials(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JBossSingleSignOnEntry localLookup(String ssoId) {
        Map map = this.cache;
        synchronized (map) {
            return (JBossSingleSignOnEntry)((Object)this.cache.get(ssoId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'"));
        }
        Map map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new JBossSingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        boolean shouldBroadcast = false;
        JBossSingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso != null) {
            if (!sso.getCanReauthenticate()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Update sso id " + ssoId + " to auth type " + authType));
                }
                JBossSingleSignOnEntry jBossSingleSignOnEntry = sso;
                synchronized (jBossSingleSignOnEntry) {
                    shouldBroadcast = sso.updateCredentials2(principal, authType, username, password);
                }
            }
            if (sso.getPrincipal() == null && principal != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Update sso id " + ssoId + " with principal " + principal.getName()));
                }
                JBossSingleSignOnEntry jBossSingleSignOnEntry = sso;
                synchronized (jBossSingleSignOnEntry) {
                    sso.setPrincipal(principal);
                }
            }
        }
        return shouldBroadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteUpdate(String ssoId, SSOCredentials credentials) {
        JBossSingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Update sso id " + ssoId + " to auth type " + credentials.getAuthType()));
            }
            JBossSingleSignOnEntry jBossSingleSignOnEntry = sso;
            synchronized (jBossSingleSignOnEntry) {
                Principal p = sso.getPrincipal();
                sso.updateCredentials(p, credentials.getAuthType(), credentials.getUsername(), credentials.getPassword());
            }
        }
    }

    public void notifySSOEmpty(String ssoId) {
        Long obj = this.emptySSOs.put(ssoId, new Long(System.currentTimeMillis()));
        if (obj == null && LOG.isTraceEnabled()) {
            LOG.trace((Object)("Notified that SSO " + ssoId + " is empty"));
        }
    }

    public void notifySSONotEmpty(String ssoId) {
        Long obj = this.emptySSOs.remove(ssoId);
        if (obj != null && LOG.isTraceEnabled()) {
            LOG.trace((Object)("Notified that SSO " + ssoId + " is no longer empty"));
        }
    }

    public MBeanServer getMBeanServer() {
        if (this.mserver == null) {
            this.mserver = Registry.getRegistry(null, null).getMBeanServer();
        }
        return this.mserver;
    }

    private void createClusterManager(String className) throws LifecycleException {
        if (this.ssoClusterManager != null) {
            return;
        }
        if (className != null) {
            SSOClusterManager mgr = null;
            try {
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = tcl.loadClass(className);
                mgr = (SSOClusterManager)clazz.newInstance();
                mgr.setSSOLocalManager((SSOLocalManager)this);
                this.ssoClusterManager = mgr;
                this.clusterManagerClass = className;
            }
            catch (Throwable t) {
                throw new LifecycleException("Cannot create SSOClusterManager using " + className, t);
            }
        } else {
            Iterator<SSOClusterManager> managers = ServiceLoader.load(SSOClusterManager.class).iterator();
            if (!managers.hasNext()) {
                throw new LifecycleException("No service provider found: " + SSOClusterManager.class.getName());
            }
            SSOClusterManager mgr = managers.next();
            mgr.setSSOLocalManager((SSOLocalManager)this);
            this.ssoClusterManager = mgr;
            this.clusterManagerClass = this.ssoClusterManager.getClass().getName();
        }
        if (this.started) {
            try {
                this.ssoClusterManager.start();
            }
            catch (LifecycleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LifecycleException("Caught exception stopping " + this.ssoClusterManager.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long now = 0L;
        Object object = this.MUTEX;
        synchronized (object) {
            now = System.currentTimeMillis();
            if (now - this.lastProcessExpires <= (long)this.processExpiresInterval) {
                return;
            }
            this.lastProcessExpires = now;
        }
        this.clearExpiredSSOs(now);
    }

    private synchronized void clearExpiredSSOs(long now) {
        for (Map.Entry<String, Long> entry : this.emptySSOs.entrySet()) {
            if (now - entry.getValue() <= (long)this.maxEmptyLife) continue;
            String ssoId = entry.getKey();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Invalidating expired SSO " + ssoId));
            }
            this.logout(ssoId);
        }
    }

    private boolean isValid(String ssoId, JBossSingleSignOnEntry entry) {
        Long expired;
        boolean valid = true;
        if (entry.getSessionCount() == 0 && (expired = this.emptySSOs.get(ssoId)) != null && System.currentTimeMillis() - expired > (long)this.maxEmptyLife) {
            valid = false;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Invalidating expired SSO " + ssoId));
            }
            this.logout(ssoId);
        }
        return valid;
    }

    private FullyQualifiedSessionId getFullyQualifiedSessionId(Session session) {
        String id = session.getIdInternal();
        Container context = session.getManager().getContainer();
        String contextName = context.getName();
        Container host = context.getParent();
        String hostName = host.getName();
        return new FullyQualifiedSessionId(id, contextName, hostName);
    }

    static {
        info = ClusteredSingleSignOn.class.getName();
    }
}

