/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.JTAResourceMBean;
import org.jboss.management.j2ee.StateManagement;
import org.jboss.management.j2ee.statistics.CountStatisticImpl;
import org.jboss.management.j2ee.statistics.JTAStatsImpl;

public class JTAResource
extends J2EEResource
implements JTAResourceMBean {
    private static Logger log = Logger.getLogger(JTAResource.class);
    private ObjectName jtaServiceName;
    private JTAStatsImpl stats;

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName jtaServiceName) {
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        ObjectName jsr77Name = null;
        try {
            JTAResource jtaRes = new JTAResource(resName, j2eeServerName, jtaServiceName);
            jsr77Name = jtaRes.getObjectName();
            mbeanServer.registerMBean(jtaRes, jsr77Name);
            log.debug((Object)("Created JSR-77 JTAResource: " + resName));
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 JTAResource: " + resName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            J2EEManagedObject.removeObject(mbeanServer, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JTAResource" + "," + "name=" + resName + "," + "*");
        }
        catch (Exception e) {
            log.error((Object)("Could not destroy JSR-77 JTAResource: " + resName), (Throwable)e);
        }
    }

    public JTAResource(String resName, ObjectName j2eeServerName, ObjectName jtaServiceName) throws MalformedObjectNameException, InvalidParentException {
        super("JTAResource", resName, j2eeServerName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service name: " + jtaServiceName));
        }
        this.jtaServiceName = jtaServiceName;
        this.stats = new JTAStatsImpl();
    }

    public Stats getstats() {
        try {
            CountStatisticImpl readyCount = (CountStatisticImpl)this.stats.getActiveCount();
            Long count = (Long)this.server.getAttribute(this.jtaServiceName, "TransactionCount");
            readyCount.set(count);
            CountStatisticImpl commitCount = (CountStatisticImpl)this.stats.getCommittedCount();
            count = (Long)this.server.getAttribute(this.jtaServiceName, "CommitCount");
            commitCount.set(count);
            CountStatisticImpl rollbackCount = (CountStatisticImpl)this.stats.getRolledbackCount();
            count = (Long)this.server.getAttribute(this.jtaServiceName, "RollbackCount");
            rollbackCount.set(count);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve stats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        this.stats.reset();
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public String toString() {
        return "JTAResource { " + super.toString() + " } [ " + " ]";
    }
}

