/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins.graph;

import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.graph.GraphController;
import org.jboss.dependency.spi.graph.LookupStrategy;
import org.jboss.dependency.spi.graph.SearchInfo;

public class SearchDependencyItem
extends AbstractDependencyItem {
    private SearchInfo search;

    public SearchDependencyItem(Object name, Object iDependOn, ControllerState whenRequired, ControllerState dependentState, SearchInfo search) {
        super(name, iDependOn, whenRequired, dependentState);
        this.search = search;
    }

    protected ControllerContext getControllerContext(Controller controller, Object name, ControllerState state) {
        LookupStrategy strategy = this.search.getStrategy();
        return strategy.getContext(controller, name, state);
    }

    public boolean resolve(Controller controller) {
        if (controller instanceof GraphController) {
            boolean previous = this.isResolved();
            ControllerContext context = this.getDependentState() == null ? this.getControllerContext(controller, this.getIDependOn(), ControllerState.INSTALLED) : this.getControllerContext(controller, this.getIDependOn(), this.getDependentState());
            if (context == null) {
                this.setResolved(false);
                ControllerContext unresolvedContext = this.getControllerContext(controller, this.getIDependOn(), null);
                if (unresolvedContext != null && ControllerMode.ON_DEMAND.equals((Object)unresolvedContext.getMode())) {
                    try {
                        controller.enableOnDemand(unresolvedContext);
                    }
                    catch (Throwable ignored) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"Unexpected error", ignored);
                        }
                    }
                }
            } else {
                this.addDependsOnMe(controller, context);
                this.setResolved(true);
            }
            if (previous != this.isResolved()) {
                this.flushJBossObjectCache();
                if (log.isTraceEnabled()) {
                    if (this.isResolved()) {
                        log.trace((Object)("Resolved " + this));
                    } else {
                        log.trace((Object)("Unresolved " + this));
                    }
                }
            }
            return this.isResolved();
        }
        return super.resolve(controller);
    }

    protected void toHumanReadableString(StringBuilder builder) {
        super.toHumanReadableString(builder);
        builder.append("search=").append(this.search);
    }
}

