/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.SSLSocketBuilderMBean;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory theDelegate;
    private SSLSocketBuilderMBean theBuilder;

    public CustomSSLSocketFactory(SSLSocketFactory factory, SSLSocketBuilder builder) {
        this.theBuilder = builder;
        this.theDelegate = factory;
    }

    public CustomSSLSocketFactory() {
    }

    public void setSSLSocketBuilder(SSLSocketBuilderMBean sslSocketBuilder) {
        this.theBuilder = sslSocketBuilder;
    }

    public SSLSocketBuilderMBean getSSLSocketBuilder() {
        return this.theBuilder;
    }

    public void setFactory(SSLSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory cannot be null");
        }
        this.theDelegate = factory;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(s, host, port, autoClose);
        this.setSocketModes(sock);
        return sock;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sock = (SSLSocket)this.theDelegate.createSocket();
        this.setSocketModes(sock);
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(address, port, localAddress, localPort);
        this.setSocketModes(sock);
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(host, port);
        this.setSocketModes(sock);
        return sock;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(host, port, localHost, localPort);
        this.setSocketModes(sock);
        return sock;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(host, port);
        this.setSocketModes(sock);
        return sock;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.theDelegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.theDelegate.getSupportedCipherSuites();
    }

    public boolean equals(Object obj) {
        return this.theDelegate.equals(obj);
    }

    public int hashCode() {
        return this.theDelegate.hashCode();
    }

    public String toString() {
        return this.theDelegate.toString();
    }

    private void setSocketModes(SSLSocket sock) {
        if (this.theBuilder != null) {
            sock.setUseClientMode(this.theBuilder.isSocketUseClientMode());
            if (this.theBuilder.isClientAuthModeWant()) {
                sock.setNeedClientAuth(false);
                sock.setWantClientAuth(true);
            } else if (this.theBuilder.isClientAuthModeNeed()) {
                sock.setWantClientAuth(false);
                sock.setNeedClientAuth(true);
            } else {
                sock.setWantClientAuth(false);
                sock.setNeedClientAuth(false);
            }
        }
    }
}

