/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MasterServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;

public class VirtualServerSocketFactory
extends ServerSocketFactory {
    protected static final Logger log = Logger.getLogger(VirtualServerSocketFactory.class);
    boolean onClient = false;

    public static ServerSocketFactory getDefault() {
        return new VirtualServerSocketFactory();
    }

    protected VirtualServerSocketFactory() {
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.isOnClient()) {
            return new VirtualServerSocket(port);
        }
        return new MasterServerSocket(port);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        if (this.isOnClient()) {
            log.warn((Object)"backlog parameter is ignored");
            return new VirtualServerSocket(port, backlog);
        }
        return new MasterServerSocket(port, backlog);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress address) throws IOException {
        if (this.isOnClient()) {
            log.warn((Object)"backlog parameter is ignored");
            return new VirtualServerSocket(port, backlog, address);
        }
        return new MasterServerSocket(port, backlog, address);
    }

    public boolean isOnClient() {
        return this.onClient;
    }

    public boolean isOnServer() {
        return !this.onClient;
    }

    public boolean setOnClient() {
        boolean temp = this.onClient;
        this.onClient = true;
        return temp;
    }

    public boolean setOnServer() {
        boolean temp = this.onClient;
        this.onClient = false;
        return !temp;
    }
}

