/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.lang;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.ejb3.common.lang.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper {
    public static <T> T cast(Class<T> targetClass, Object obj) {
        try {
            return targetClass.cast(obj);
        }
        catch (ClassCastException e) {
            assert (obj != null) : "a null can always be cast, it should never throw a ClassCastException";
            throw new ClassCastException("Unable to cast " + obj.getClass() + " to " + targetClass);
        }
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    private static Method findPrivateMethod(Class<?> target, String methodName, Class<?> ... paramTypes) {
        if (target == null) {
            return null;
        }
        for (Method method : SecurityActions.getDeclaredMethods(target)) {
            if (!method.getName().equals(methodName)) continue;
            if (paramTypes == null) {
                return method;
            }
            if (!Arrays.equals(method.getParameterTypes(), paramTypes)) continue;
            return method;
        }
        return ClassHelper.findPrivateMethod(target.getSuperclass(), methodName, paramTypes);
    }

    public static List<Method> getAllMethodsByName(Class<?> cls, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassHelper.populateWithMethodsByName(methods, cls, methodName);
        return methods;
    }

    public static List<Method> getAllMethodsByPrefix(Class<?> clazz, String methodNamePrefix) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassHelper.populateWithMethodsByPrefix(methods, clazz, methodNamePrefix);
        return methods;
    }

    public static Method getPrivateMethod(Class<?> cls, String methodName, Class<?> ... paramTypes) throws NoSuchMethodException {
        assert (cls != null) : "cls is null";
        assert (methodName != null) : "methodName is null";
        Method result = ClassHelper.findPrivateMethod(cls, methodName, paramTypes);
        if (result == null) {
            throw new NoSuchMethodException(cls.getName() + "." + methodName + ClassHelper.argumentTypesToString(paramTypes));
        }
        return result;
    }

    public static final Class<?> getClassFromTypeName(String type, ClassLoader cl) {
        try {
            return cl.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Specified class " + type + " could not be found by the " + ClassLoader.class.getSimpleName() + ", " + cl, e);
        }
    }

    private static void populateWithMethodsByName(List<Method> methods, Class<?> cls, String methodName) {
        if (cls == null) {
            return;
        }
        for (Method method : SecurityActions.getDeclaredMethods(cls)) {
            if (!method.getName().equals(methodName)) continue;
            methods.add(method);
        }
        ClassHelper.populateWithMethodsByName(methods, cls.getSuperclass(), methodName);
    }

    private static void populateWithMethodsByPrefix(List<Method> methods, Class<?> clazz, String methodNamePrefix) {
        if (clazz == null) {
            return;
        }
        for (Method method : SecurityActions.getDeclaredMethods(clazz)) {
            if (!method.getName().startsWith(methodNamePrefix)) continue;
            methods.add(method);
        }
        ClassHelper.populateWithMethodsByPrefix(methods, clazz.getSuperclass(), methodNamePrefix);
    }
}

