/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactAttachmentDeployerWithVisitor<T>
extends AbstractRealDeployer {
    private String attachmentName;
    private DeploymentVisitor<T> visitor;

    public ExactAttachmentDeployerWithVisitor(String attachmentName, DeploymentVisitor<T> visitor) {
        if (attachmentName == null) {
            throw new IllegalArgumentException("Null attachment name");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.attachmentName = attachmentName;
        this.visitor = visitor;
        this.setInput(visitor.getVisitorType());
    }

    @Override
    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        Class<T> attachmentType = this.visitor.getVisitorType();
        Object attachment = unit.getAttachment(this.attachmentName, attachmentType);
        if (attachment == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Skipping " + this.visitor + " during deploy, since no attachment named " + this.attachmentName + " of type " + attachmentType + " found in unit " + unit));
            }
            return;
        }
        this.visitor.deploy(unit, attachment);
    }

    @Override
    protected void internalUndeploy(DeploymentUnit unit) {
        Class<T> attachmentType = this.visitor.getVisitorType();
        Object attachment = unit.getAttachment(this.attachmentName, attachmentType);
        if (attachment == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Skipping " + this.visitor + " during undeploy, since no attachment named " + this.attachmentName + " of type " + attachmentType + " found in unit " + unit));
            }
            return;
        }
        this.visitor.undeploy(unit, attachment);
    }
}

