/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.aop.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aspects.currentinvocation.CurrentInvocationInterceptor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisorHelper;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackBeanMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackInterceptorMethodLazyInterceptor;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.logging.Logger;

@Deprecated
class LifecycleCallbacks {
    private static final Logger log = Logger.getLogger(LifecycleCallbacks.class);

    LifecycleCallbacks() {
    }

    private static HashSet<Class<?>> checkClass(HashSet<Class<?>> classes, Method m, Advisor advisor, Class<? extends Annotation> lifecycleAnnotationType) {
        if (classes != null) {
            if (classes.contains(m.getDeclaringClass())) {
                String type = null;
                if (lifecycleAnnotationType == PostConstruct.class) {
                    type = "post-construct";
                } else if (lifecycleAnnotationType == PreDestroy.class) {
                    type = "pre-destroy";
                } else if (lifecycleAnnotationType == PostActivate.class) {
                    type = "post-activate";
                } else if (lifecycleAnnotationType == PrePassivate.class) {
                    type = "pre-passivate";
                }
                throw new RuntimeException("More than one '" + type + "' method in " + advisor.getName());
            }
        } else {
            classes = new HashSet();
        }
        classes.add(m.getDeclaringClass());
        return classes;
    }

    public static Interceptor[] createLifecycleCallbackInterceptors(Advisor advisor, List<Class<?>> lifecycleInterceptorClasses, Class<? extends Annotation> lifecycleAnnotationType, String stackName) {
        Method[] possibleLifecycleMethods;
        ArrayList<Object> interceptors = new ArrayList<Object>();
        AdviceStack stack = advisor.getManager().getAdviceStack(stackName);
        if (stack == null) {
            Interceptor invocationContextInterceptor;
            log.warn((Object)("EJBTHREE-1480: " + stackName + " has not been defined for " + LifecycleCallbacks.toString(advisor.getManager())));
            interceptors.add(new CurrentInvocationInterceptor());
            try {
                invocationContextInterceptor = PerVmAdvice.generateInterceptor(null, (Object)new InvocationContextInterceptor(), (String)"setup");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate invocation context interceptor", e);
            }
            interceptors.add(invocationContextInterceptor);
        } else {
            interceptors.addAll(Arrays.asList(stack.createInterceptors(advisor, null)));
        }
        for (Class<?> interceptorClass : lifecycleInterceptorClasses) {
            Method[] possibleLifecycleInterceptorMethods;
            ExtendedAdvisor interceptorAdvisor = ExtendedAdvisorHelper.getExtendedAdvisor((Advisor)advisor);
            HashSet<Class<?>> classes = null;
            for (Method interceptorMethod : possibleLifecycleInterceptorMethods = ClassHelper.getMethods(interceptorClass, Void.TYPE, (Class[])new Class[]{InvocationContext.class})) {
                if (!interceptorAdvisor.isAnnotationPresent(interceptorClass, (Member)interceptorMethod, lifecycleAnnotationType) || ClassHelper.isOverridden(interceptorClass, (Method)interceptorMethod)) continue;
                classes = LifecycleCallbacks.checkClass(classes, interceptorMethod, advisor, lifecycleAnnotationType);
                interceptors.add(new LifecycleCallbackInterceptorMethodLazyInterceptor(interceptorClass, interceptorMethod));
            }
        }
        Class beanClass = advisor.getClazz();
        HashSet<Class<?>> classes = null;
        for (Method beanMethod : possibleLifecycleMethods = ClassHelper.getMethods((Class)beanClass, Void.TYPE, (Class[])new Class[0])) {
            if (!advisor.hasAnnotation(beanMethod, lifecycleAnnotationType) || ClassHelper.isOverridden((Class)beanClass, (Method)beanMethod)) continue;
            classes = LifecycleCallbacks.checkClass(classes, beanMethod, advisor, lifecycleAnnotationType);
            interceptors.add(new LifecycleCallbackBeanMethodInterceptor(beanMethod));
        }
        return interceptors.toArray(new Interceptor[0]);
    }

    private static String toString(AspectManager manager) {
        if (manager instanceof Domain) {
            return "domain '" + ((Domain)manager).getDomainName() + "'";
        }
        return manager.toString();
    }
}

