/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.config.ArtifactRepositoriesConfig;
import org.jboss.profileservice.config.ManagementDomain;
import org.jboss.profileservice.config.PersistenceRepositoryConfiguration;
import org.jboss.profileservice.config.ServerConfiguration;
import org.jboss.profileservice.config.VirtualAssemblyConfiguration;
import org.jboss.profileservice.dependency.plugin.ProfileLifeCycleCallbackActions;
import org.jboss.profileservice.deployment.ProfileDeployerPluginRegistry;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.activation.ProfileActivator;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class ProfileServiceConfig {
    private ManagementDomain managementDomain;
    private ServerConfiguration serverConfiguration;
    private ProfileLifeCycleCallbackActions lifeCycleActions;
    private ProfileFactory<ProfileMetaData, Profile> profileFactory;
    private ProfileDeployerPluginRegistry deployerRegistry;
    private PersistenceRepositoryConfiguration persistenceRepositoryConfiguration;
    private ArtifactRepositoriesConfig repositoriesConfiguration = ArtifactRepositoriesConfig.getInstance();
    private VirtualAssemblyConfiguration assemblyConfiguration = new VirtualAssemblyConfiguration();
    private Map<String, ProfileActivator> activators = new ConcurrentHashMap<String, ProfileActivator>();

    public ProfileServiceConfig() {
    }

    public ProfileServiceConfig(ManagementDomain managementDomain, ServerConfiguration serverConfiguration) {
        this.managementDomain = managementDomain;
        this.serverConfiguration = serverConfiguration;
    }

    public ManagementDomain getManagementDomain() {
        return this.managementDomain;
    }

    public void setManagementDomain(ManagementDomain managementDomain) {
        this.managementDomain = managementDomain;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void setServerConfiguration(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public ProfileLifeCycleCallbackActions getLifeCycleActions() {
        return this.lifeCycleActions;
    }

    public void setLifeCycleActions(ProfileLifeCycleCallbackActions lifeCycleActions) {
        this.lifeCycleActions = lifeCycleActions;
    }

    public ProfileDeployerPluginRegistry getDeployerRegistry() {
        return this.deployerRegistry;
    }

    public void setDeployerRegistry(ProfileDeployerPluginRegistry deployerRegistry) {
        this.deployerRegistry = deployerRegistry;
    }

    public ProfileFactory<ProfileMetaData, Profile> getProfileFactory() {
        return this.profileFactory;
    }

    public void setProfileFactory(ProfileFactory<ProfileMetaData, Profile> profileFactory) {
        this.profileFactory = profileFactory;
    }

    public PersistenceRepositoryConfiguration getPersistenceRepositoryConfiguration() {
        return this.persistenceRepositoryConfiguration;
    }

    public void setPersistenceRepositoryConfiguration(PersistenceRepositoryConfiguration persistenceRepositoryConfiguration) {
        this.persistenceRepositoryConfiguration = persistenceRepositoryConfiguration;
    }

    public ArtifactRepositoriesConfig getRepositoriesConfiguration() {
        return this.repositoriesConfiguration;
    }

    public void setRepositoriesConfiguration(ArtifactRepositoriesConfig repositoriesConfiguration) {
        this.repositoriesConfiguration = repositoriesConfiguration;
    }

    public VirtualAssemblyConfiguration getAssemblyConfiguration() {
        return this.assemblyConfiguration;
    }

    public void setAssemblyConfiguration(VirtualAssemblyConfiguration assemblyConfiguration) {
        this.assemblyConfiguration = assemblyConfiguration;
    }

    public ProfileActivator getProfileActivator(String name) {
        return this.activators.get(name);
    }

    public void addProfileActivator(ProfileActivator activator) {
        if (activator == null) {
            throw new IllegalArgumentException("null activator");
        }
        if (activator.getActivatorReference() == null) {
            throw new IllegalArgumentException("null artivator reference");
        }
        this.activators.put(activator.getActivatorReference(), activator);
    }

    public void removeProfileActivator(ProfileActivator activator) {
        this.activators.remove(activator.getActivatorReference());
    }
}

