/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileCapability;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.deployment.MetaDataAttachmentHolder;
import org.jboss.profileservice.spi.deployment.MetaDataAttachmentVisitor;
import org.jboss.profileservice.spi.metadata.ProfileDeploymentMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitor;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.virtual.VirtualArtifactMetaData;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.profileservice.virtual.deployment.AbstractVirtualFileArtifact;
import org.jboss.profileservice.virtual.deployment.VirtualMavenArtifactMetaData;
import org.jboss.vfs.VirtualFile;

@XmlType(propOrder={"name", "artifact", "artifacts"})
public class BootstrapProfileDeploymentMetaData
extends AbstractProfileCapability
implements ProfileDeploymentMetaData,
MetaDataAttachmentHolder {
    private static final long serialVersionUID = -4689990538934087617L;
    private VirtualArtifactMetaData artifact;
    private List<VirtualArtifactMetaData> artifacts;

    @XmlElement(name="meta-inf", type=AbstractVirtualFileArtifact.class)
    public VirtualArtifactMetaData getArtifact() {
        return this.artifact;
    }

    public void setArtifact(VirtualArtifactMetaData artifact) {
        this.artifact = artifact;
    }

    @XmlElement(name="artifact", type=VirtualMavenArtifactMetaData.class)
    public List<VirtualArtifactMetaData> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<VirtualArtifactMetaData> artifacts) {
        this.artifacts = artifacts;
    }

    @XmlTransient
    public List<VirtualDeploymentMetaData> getChildren() {
        return Collections.emptyList();
    }

    @XmlTransient
    public boolean isConsistent(ProfileCapability other) {
        return true;
    }

    @XmlTransient
    public boolean resolves(ProfileRequirement requirement) {
        return false;
    }

    public void visit(ProfileMetaDataVisitor visitor) {
    }

    public void visit(MetaDataAttachmentVisitor visitor) {
        if (this.artifacts != null && !this.artifacts.isEmpty() && visitor instanceof VirtualDeploymentRepository) {
            ArrayList<String> roots = new ArrayList<String>();
            VirtualDeploymentRepository delegate = (VirtualDeploymentRepository)VirtualDeploymentRepository.class.cast(visitor);
            for (VirtualArtifactMetaData artifact : this.artifacts) {
                try {
                    ArtifactRepository artifactRepository = delegate.resolveArtifactRepository((ArtifactId)artifact);
                    VirtualFile vf = artifactRepository.getOriginalFile((ArtifactId)artifact);
                    roots.add(vf.toURI().toString());
                }
                catch (Exception e) {
                    throw new RuntimeException("failed to resolve artifact: " + artifact, e);
                }
            }
            VFSClassLoaderFactory classloaderFactory = new VFSClassLoaderFactory();
            classloaderFactory.setName(this.getName());
            classloaderFactory.setExportAll(ExportAll.NON_EMPTY);
            classloaderFactory.setImportAll(true);
            classloaderFactory.setRoots(roots);
            visitor.getPredeterminedAttachments().putAttachment(ClassLoadingMetaData.class.getName(), (Object)classloaderFactory);
        }
    }
}

