/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.virtual;

import java.io.IOException;
import java.util.Collection;
import org.jboss.profileservice.deployment.ProfileDeploymentFactory;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.deployment.DeploymentAttachments;
import org.jboss.profileservice.spi.deployment.MetaDataAttachmentHolder;
import org.jboss.profileservice.spi.deployment.MetaDataAttachmentVisitor;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.profileservice.spi.virtual.assembly.VirtualDeploymentAssemblyContext;
import org.jboss.profileservice.virtual.assembly.AbstractVirtualDeploymentAssembly;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractVirtualDeploymentRepository
extends AbstractVirtualDeploymentAssembly {
    public static final String ASSEMBLED_ATTACHMENT_NAME = VirtualDeploymentAssemblyContext.class.getName();
    private static final ProfileDeploymentFactory deploymentFactory = ProfileDeploymentFactory.getInstance();

    public ProfileDeployment createDeployment(VirtualDeploymentMetaData deployment) throws IOException {
        if (deployment == null) {
            throw new IllegalArgumentException("null virtual deployment");
        }
        VirtualDeploymentAssemblyContext ctx = this.assemble(deployment);
        VirtualFile vf = ctx.getRoot();
        if (vf == null) {
            throw new IllegalStateException("Assembled null virtual file");
        }
        ProfileDeployment profileDeployment = deploymentFactory.createDeployment(vf, deployment);
        profileDeployment.getTransientAttachments().putAttachment(ASSEMBLED_ATTACHMENT_NAME, (Object)ctx);
        this.visitAttachments(profileDeployment);
        return profileDeployment;
    }

    @Override
    protected VirtualFile getOriginalVirtualFile(ArtifactId artifactId) throws IOException {
        return this.resolveRepository(artifactId).getOriginalFile(artifactId);
    }

    protected abstract ArtifactRepository<ArtifactId> resolveRepository(ArtifactId var1);

    protected abstract VirtualDeploymentRepository getDeploymentRepository();

    protected void visitAttachments(ProfileDeployment deployment) {
        VirtualDeploymentMetaData deploymentMetaData = deployment.getDeploymentInfo().getMetaData();
        if (deploymentMetaData instanceof MetaDataAttachmentHolder) {
            BasicAttachmentVisitor visitor = new BasicAttachmentVisitor(deployment, this.getDeploymentRepository());
            visitor.visit((MetaDataAttachmentHolder)MetaDataAttachmentHolder.class.cast(deploymentMetaData));
        }
    }

    public static class BasicAttachmentVisitor
    implements MetaDataAttachmentVisitor,
    VirtualDeploymentRepository {
        final ProfileDeployment deployment;
        final VirtualDeploymentRepository deploymentRepository;

        public BasicAttachmentVisitor(ProfileDeployment deployment, VirtualDeploymentRepository deploymentRepository) {
            this.deployment = deployment;
            this.deploymentRepository = deploymentRepository;
        }

        public DeploymentAttachments getPredeterminedAttachments() {
            return this.deployment.getPredeterminedAttachments();
        }

        public DeploymentAttachments getTransientAttachments() {
            return this.deployment.getTransientAttachments();
        }

        public void visit(MetaDataAttachmentHolder attachmentHolder) {
            attachmentHolder.visit((MetaDataAttachmentVisitor)this);
        }

        public ProfileDeployment createDeployment(VirtualDeploymentMetaData virtual) throws IOException {
            return this.deploymentRepository.createDeployment(virtual);
        }

        public Collection<ArtifactRepositoryId> getRepositoryIDs() {
            return this.deploymentRepository.getRepositoryIDs();
        }

        public <T extends ArtifactId> ArtifactRepository<T> resolveArtifactRepository(T artifactId) {
            return this.deploymentRepository.resolveArtifactRepository(artifactId);
        }
    }
}

